/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionValueVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.AbstractChangeSetsConflictResolver;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMergingConflictResolver
extends AbstractChangeSetsConflictResolver {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, CDOViewImpl.class);
    private CDOMerger merger;

    public CDOMergingConflictResolver(CDOMerger merger) {
        this.merger = merger;
    }

    public CDOMergingConflictResolver(DefaultCDOMerger.ResolutionPreference resolutionPreference) {
        this(new DefaultCDOMerger.PerFeature.ManyValued(resolutionPreference));
    }

    public CDOMergingConflictResolver() {
        this(new DefaultCDOMerger.PerFeature.ManyValued());
    }

    public CDOMerger getMerger() {
        return this.merger;
    }

    @Override
    public void resolveConflicts(Set<CDOObject> conflicts) {
        CDOChangeSetData result;
        CDOChangeSet localChangeSet = this.getLocalChangeSet();
        CDOChangeSet remoteChangeSet = this.getRemoteChangeSet();
        try {
            result = this.merger.merge(localChangeSet, remoteChangeSet);
        }
        catch (CDOMerger.ConflictException ex) {
            return;
        }
        InternalCDOTransaction transaction = (InternalCDOTransaction)this.getTransaction();
        InternalCDOSavepoint savepoint = transaction.getLastSavepoint();
        Map<InternalCDOObject, InternalCDORevision> cleanRevisions = transaction.getCleanRevisions();
        Map<CDOID, CDOObject> dirtyObjects = savepoint.getDirtyObjects();
        final ObjectsMapUpdater detachedObjectsUpdater = new ObjectsMapUpdater(savepoint.getDetachedObjects());
        Map<CDOID, CDORevisionDelta> localDeltas = savepoint.getRevisionDeltas2();
        Map<CDOID, CDORevisionDelta> remoteDeltas = this.getRemoteDeltas(remoteChangeSet);
        for (CDORevisionKey key : result.getChangedObjects()) {
            InternalCDORevisionDelta resultDelta = (InternalCDORevisionDelta)key;
            CDOID id = resultDelta.getID();
            InternalCDOObject object = (InternalCDOObject)transaction.getObject(id, false);
            if (object == null) continue;
            InternalCDORevision localRevision = object.cdoRevision();
            int newVersion = localRevision.getVersion() + 1;
            InternalCDORevision cleanRevision = cleanRevisions.get(object);
            if (cleanRevision == null) {
                cleanRevision = object.cdoRevision();
            }
            InternalCDORevision newLocalRevision = cleanRevision.copy();
            newLocalRevision.setVersion(newVersion);
            resultDelta.apply((CDORevision)newLocalRevision);
            object.cdoInternalSetRevision((CDORevision)newLocalRevision);
            CDORevisionDelta remoteDelta = remoteDeltas.get(id);
            InternalCDORevision newCleanRevision = cleanRevision.copy();
            newCleanRevision.setVersion(newVersion);
            remoteDelta.apply((CDORevision)newCleanRevision);
            InternalCDORevisionDelta newLocalDelta = newLocalRevision.compare((CDORevision)newCleanRevision);
            if (newLocalDelta.isEmpty()) {
                localDeltas.remove(id);
                object.cdoInternalSetState(CDOState.CLEAN);
                dirtyObjects.remove(id);
                continue;
            }
            newLocalDelta.setTarget(null);
            localDeltas.put(id, (CDORevisionDelta)newLocalDelta);
            object.cdoInternalSetState(CDOState.DIRTY);
            cleanRevisions.put(object, newCleanRevision);
            dirtyObjects.put(id, object);
            newLocalDelta.accept((CDOFeatureDeltaVisitor)new CDOFeatureDeltaVisitorImpl(){

                public void visit(CDOAddFeatureDelta delta) {
                }

                public void visit(CDOClearFeatureDelta delta) {
                }

                public void visit(CDORemoveFeatureDelta delta) {
                    this.recurse(detachedObjectsUpdater, (CDOID)delta.getValue());
                }

                public void visit(CDOSetFeatureDelta delta) {
                }

                public void visit(CDOUnsetFeatureDelta delta) {
                }

                private void recurse(final ObjectsMapUpdater objectsUpdater, CDOID id) {
                    InternalCDORevision revision;
                    CDOObject object = objectsUpdater.update(id);
                    if (object != null && (revision = (InternalCDORevision)object.cdoRevision()) != null) {
                        revision.accept(new CDORevisionValueVisitor(){

                            public void visit(EStructuralFeature feature, Object value, int index) {
                                this.recurse(objectsUpdater, (CDOID)value);
                            }
                        }, EMFUtil.CONTAINMENT_REFERENCES);
                    }
                }
            }, EMFUtil.CONTAINMENT_REFERENCES);
        }
    }

    private Map<CDOID, CDORevisionDelta> getRemoteDeltas(CDOChangeSet remoteChangeSet) {
        Map remoteDeltas = CDOIDUtil.createMap();
        for (CDORevisionKey key : remoteChangeSet.getChangedObjects()) {
            if (key instanceof CDORevisionDelta) {
                CDORevisionDelta delta = (CDORevisionDelta)key;
                remoteDeltas.put(key.getID(), delta);
                continue;
            }
            if (!TRACER.isEnabled()) continue;
            TRACER.format("Not a CDORevisionDelta: {0}", new Object[]{key});
        }
        return remoteDeltas;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ObjectsMapUpdater {
        private final Map<CDOID, CDOObject> map;
        private final Map<CDOID, CDOObject> mapCopy;

        public ObjectsMapUpdater(Map<CDOID, CDOObject> map) {
            this.mapCopy = new HashMap<CDOID, CDOObject>(map);
            map.clear();
            this.map = map;
        }

        public CDOObject update(CDOID id) {
            CDOObject object = this.mapCopy.get(id);
            if (object == null) {
                object = CDOMergingConflictResolver.this.getTransaction().getObject(id, true);
            }
            if (object != null) {
                this.map.put(id, object);
                return object;
            }
            return null;
        }
    }
}

