/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class CDOSessionInvalidationEventQueue {
    private CDOSession session;
    private IListener sessionListener = new IListener(){

        public void notifyEvent(IEvent event) {
            try {
                if (event instanceof CDOSessionInvalidationEvent) {
                    CDOSessionInvalidationEvent e = (CDOSessionInvalidationEvent)event;
                    CDOSessionInvalidationEventQueue.this.handleEvent(e);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    };
    private Queue<CDOChangeSetData> queue = new ConcurrentLinkedQueue<CDOChangeSetData>();

    public CDOSessionInvalidationEventQueue(CDOSession session) {
        this.session = session;
        session.addListener(this.sessionListener);
    }

    public void dispose() {
        this.reset();
        this.session.removeListener(this.sessionListener);
        this.session = null;
    }

    public CDOSession getSession() {
        return this.session;
    }

    public CDOChangeSetData getChangeSetData() {
        return this.queue.poll();
    }

    public void reset() {
        this.queue.clear();
    }

    protected void handleEvent(CDOSessionInvalidationEvent event) throws Exception {
        this.queue.offer((CDOChangeSetData)event);
    }
}

