/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.core.request.handler.BookmarkableListenerInterfaceRequestHandler;
import org.apache.wicket.core.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.ListenerInterfaceRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.mapper.AbstractComponentMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.ComponentInfo;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.info.PageInfo;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBookmarkableMapper
extends AbstractComponentMapper {
    private static Logger logger = LoggerFactory.getLogger(AbstractBookmarkableMapper.class);

    protected abstract UrlInfo parseRequest(Request var1);

    protected abstract Url buildUrl(UrlInfo var1);

    protected abstract boolean pageMustHaveBeenCreatedBookmarkable();

    public abstract int getCompatibilityScore(Request var1);

    protected IRequestHandler processBookmarkable(Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
        PageProvider provider = new PageProvider(pageClass, pageParameters);
        provider.setPageSource(this.getContext());
        return new RenderPageRequestHandler(provider);
    }

    protected IRequestHandler processHybrid(PageInfo pageInfo, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount) {
        PageProvider provider = new PageProvider(pageInfo.getPageId(), pageClass, pageParameters, renderCount);
        provider.setPageSource(this.getContext());
        return new RenderPageRequestHandler(provider);
    }

    protected IRequestHandler processListener(PageComponentInfo pageComponentInfo, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
        PageInfo pageInfo = pageComponentInfo.getPageInfo();
        ComponentInfo componentInfo = pageComponentInfo.getComponentInfo();
        Integer renderCount = null;
        RequestListenerInterface listenerInterface = null;
        if (componentInfo != null) {
            renderCount = componentInfo.getRenderCount();
            listenerInterface = this.requestListenerInterfaceFromString(componentInfo.getListenerInterface());
        }
        if (listenerInterface != null) {
            PageAndComponentProvider provider = new PageAndComponentProvider(pageInfo.getPageId(), pageClass, pageParameters, renderCount, componentInfo.getComponentPath());
            provider.setPageSource(this.getContext());
            return new ListenerInterfaceRequestHandler(provider, listenerInterface, componentInfo.getBehaviorId());
        }
        if (logger.isWarnEnabled()) {
            if (componentInfo != null) {
                logger.warn("Unknown listener interface '{}'", (Object)componentInfo.getListenerInterface());
            } else {
                logger.warn("Cannot extract the listener interface for PageComponentInfo: '{}'" + pageComponentInfo);
            }
        }
        return null;
    }

    public IRequestHandler mapRequest(Request request) {
        UrlInfo urlInfo = this.parseRequest(request);
        if (urlInfo != null) {
            PageComponentInfo info = urlInfo.getPageComponentInfo();
            Class<? extends IRequestablePage> pageClass = urlInfo.getPageClass();
            PageParameters pageParameters = urlInfo.getPageParameters();
            if (info == null) {
                return this.processBookmarkable(pageClass, pageParameters);
            }
            if (info.getPageInfo().getPageId() != null && info.getComponentInfo() == null) {
                return this.processHybrid(info.getPageInfo(), pageClass, pageParameters, null);
            }
            if (info.getComponentInfo() != null) {
                return this.processListener(info, pageClass, pageParameters);
            }
            if (info.getPageInfo().getPageId() == null) {
                return this.processBookmarkable(pageClass, pageParameters);
            }
        }
        return null;
    }

    protected boolean checkPageInstance(IRequestablePage page) {
        return page != null && this.checkPageClass(page.getClass());
    }

    protected boolean checkPageClass(Class<? extends IRequestablePage> pageClass) {
        return true;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        while (requestHandler instanceof IRequestHandlerDelegate) {
            requestHandler = ((IRequestHandlerDelegate)requestHandler).getDelegateHandler();
        }
        if (requestHandler instanceof BookmarkablePageRequestHandler) {
            BookmarkablePageRequestHandler handler = (BookmarkablePageRequestHandler)requestHandler;
            if (!this.checkPageClass(handler.getPageClass())) {
                return null;
            }
            PageInfo info = new PageInfo();
            UrlInfo urlInfo = new UrlInfo(new PageComponentInfo(info, null), handler.getPageClass(), handler.getPageParameters());
            return this.buildUrl(urlInfo);
        }
        if (requestHandler instanceof RenderPageRequestHandler) {
            RenderPageRequestHandler handler = (RenderPageRequestHandler)requestHandler;
            if (!this.checkPageClass(handler.getPageClass())) {
                return null;
            }
            if (handler.getPageProvider().isNewPageInstance()) {
                PageInfo info = new PageInfo();
                UrlInfo urlInfo = new UrlInfo(new PageComponentInfo(info, null), handler.getPageClass(), handler.getPageParameters());
                return this.buildUrl(urlInfo);
            }
            IRequestablePage page = handler.getPage();
            if (this.checkPageInstance(page) && (!this.pageMustHaveBeenCreatedBookmarkable() || page.wasCreatedBookmarkable())) {
                PageInfo info = this.getPageInfo(handler);
                PageComponentInfo pageComponentInfo = info != null ? new PageComponentInfo(info, null) : null;
                UrlInfo urlInfo = new UrlInfo(pageComponentInfo, page.getClass(), handler.getPageParameters());
                return this.buildUrl(urlInfo);
            }
            return null;
        }
        if (requestHandler instanceof BookmarkableListenerInterfaceRequestHandler) {
            BookmarkableListenerInterfaceRequestHandler handler = (BookmarkableListenerInterfaceRequestHandler)requestHandler;
            Class<? extends IRequestablePage> pageClass = handler.getPageClass();
            if (!this.checkPageClass(pageClass)) {
                return null;
            }
            Integer renderCount = null;
            if (handler.getListenerInterface().isIncludeRenderCount()) {
                renderCount = handler.getRenderCount();
            }
            PageInfo pageInfo = this.getPageInfo(handler);
            ComponentInfo componentInfo = new ComponentInfo(renderCount, this.requestListenerInterfaceToString(handler.getListenerInterface()), handler.getComponentPath(), handler.getBehaviorIndex());
            UrlInfo urlInfo = new UrlInfo(new PageComponentInfo(pageInfo, componentInfo), pageClass, handler.getPageParameters());
            return this.buildUrl(urlInfo);
        }
        return null;
    }

    protected final PageInfo getPageInfo(IPageRequestHandler handler) {
        IRequestablePage page;
        Args.notNull((Object)handler, (String)"handler");
        Integer pageId = null;
        if (handler.isPageInstanceCreated() && !(page = handler.getPage()).isPageStateless()) {
            pageId = page.getPageId();
        }
        return new PageInfo(pageId);
    }

    protected static final class UrlInfo {
        private final PageComponentInfo pageComponentInfo;
        private final PageParameters pageParameters;
        private final Class<? extends IRequestablePage> pageClass;

        public UrlInfo(PageComponentInfo pageComponentInfo, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
            Args.notNull(pageClass, (String)"pageClass");
            this.pageComponentInfo = pageComponentInfo;
            this.pageParameters = this.cleanPageParameters(pageParameters);
            this.pageClass = pageClass;
        }

        private PageParameters cleanPageParameters(PageParameters originalParameters) {
            PageParameters cleanParameters = null;
            if (originalParameters != null) {
                cleanParameters = new PageParameters(originalParameters);
                cleanParameters.remove("wicket-ajax", new String[0]);
                cleanParameters.remove("wicket-ajax-baseurl", new String[0]);
                cleanParameters.remove("random", new String[0]);
                if (cleanParameters.isEmpty()) {
                    cleanParameters = null;
                }
            }
            return cleanParameters;
        }

        public PageComponentInfo getPageComponentInfo() {
            return this.pageComponentInfo;
        }

        public Class<? extends IRequestablePage> getPageClass() {
            return this.pageClass;
        }

        public PageParameters getPageParameters() {
            return this.pageParameters;
        }
    }
}

