/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestLogger
implements IRequestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRequestLogger.class);
    private static MetaDataKey<IRequestLogger.RequestData> REQUEST_DATA = new MetaDataKey<IRequestLogger.RequestData>(){
        private static final long serialVersionUID = 1L;
    };
    private static MetaDataKey<IRequestLogger.SessionData> SESSION_DATA = new MetaDataKey<IRequestLogger.SessionData>(){
        private static final long serialVersionUID = 1L;
    };
    private final AtomicInteger totalCreatedSessions = new AtomicInteger();
    private final AtomicInteger peakSessions = new AtomicInteger();
    private final Map<String, IRequestLogger.SessionData> liveSessions;
    private final AtomicInteger activeRequests = new AtomicInteger();
    private final AtomicInteger peakActiveRequests = new AtomicInteger();
    private IRequestLogger.RequestData[] requestWindow;
    private int indexInWindow = 0;
    private long totalRequestTime = 0L;
    private Date startTimeOfOldestRequest;

    public AbstractRequestLogger() {
        int requestsWindowSize = Application.get().getRequestLoggerSettings().getRequestsWindowSize();
        this.requestWindow = new IRequestLogger.RequestData[requestsWindowSize];
        this.liveSessions = new ConcurrentHashMap<String, IRequestLogger.SessionData>();
    }

    @Override
    public int getCurrentActiveRequestCount() {
        return this.activeRequests.get();
    }

    @Override
    public int getPeakActiveRequestCount() {
        return this.peakActiveRequests.get();
    }

    @Override
    public IRequestLogger.SessionData[] getLiveSessions() {
        Object[] sessions = this.liveSessions.values().toArray(new IRequestLogger.SessionData[this.liveSessions.values().size()]);
        Arrays.sort(sessions);
        return sessions;
    }

    @Override
    public int getPeakSessions() {
        return this.peakSessions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IRequestLogger.RequestData> getRequests() {
        IRequestLogger.RequestData[] requestDataArray = this.requestWindow;
        synchronized (this.requestWindow) {
            IRequestLogger.RequestData[] result = new IRequestLogger.RequestData[this.hasBufferRolledOver() ? this.requestWindow.length : this.indexInWindow];
            this.copyRequestsInOrder(result);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.asList(result);
        }
    }

    private void copyRequestsInOrder(IRequestLogger.RequestData[] copy) {
        if (this.hasBufferRolledOver()) {
            int oldestPos = this.indexInWindow + 1;
            if (oldestPos < this.requestWindow.length) {
                System.arraycopy(this.requestWindow, oldestPos, copy, 0, this.requestWindow.length - oldestPos);
            }
            System.arraycopy(this.requestWindow, 0, copy, this.requestWindow.length - oldestPos, this.indexInWindow);
        } else {
            System.arraycopy(this.requestWindow, 0, copy, 0, this.indexInWindow);
        }
    }

    private boolean hasBufferRolledOver() {
        return this.requestWindow[this.requestWindow.length - 1] != null;
    }

    @Override
    public int getTotalCreatedSessions() {
        return this.totalCreatedSessions.get();
    }

    @Override
    public void objectCreated(Object value) {
    }

    @Override
    public void objectRemoved(Object value) {
    }

    @Override
    public void objectUpdated(Object value) {
    }

    @Override
    public void requestTime(long timeTaken) {
        IRequestLogger.RequestData requestdata = RequestCycle.get().getMetaData(REQUEST_DATA);
        if (requestdata != null) {
            if (this.activeRequests.get() > 0) {
                requestdata.setActiveRequest(this.activeRequests.decrementAndGet());
            }
            Session session = Session.get();
            String sessionId = session.getId();
            requestdata.setSessionId(sessionId);
            Object sessionInfo = this.getSessionInfo(session);
            requestdata.setSessionInfo(sessionInfo);
            long sizeInBytes = -1L;
            if (Application.get().getRequestLoggerSettings().getRecordSessionSize()) {
                try {
                    sizeInBytes = session.getSizeInBytes();
                }
                catch (Exception e) {
                    LOG.error("Exception while determining the size of the session in the request logger: " + e.getMessage(), (Throwable)e);
                }
            }
            requestdata.setSessionSize(sizeInBytes);
            requestdata.setTimeTaken(timeTaken);
            this.addRequest(requestdata);
            IRequestLogger.SessionData sessiondata = null;
            if (sessionId != null) {
                sessiondata = this.liveSessions.get(sessionId);
                if (sessiondata == null) {
                    sessiondata = RequestCycle.get().getMetaData(SESSION_DATA);
                }
                if (sessiondata == null) {
                    this.sessionCreated(sessionId);
                    sessiondata = this.liveSessions.get(sessionId);
                }
                if (sessiondata != null) {
                    sessiondata.setSessionInfo(sessionInfo);
                    sessiondata.setSessionSize(sizeInBytes);
                    sessiondata.addTimeTaken(timeTaken);
                    RequestCycle.get().setMetaData(SESSION_DATA, sessiondata);
                }
            }
        }
    }

    @Override
    public void sessionCreated(String sessionId) {
        this.liveSessions.put(sessionId, new IRequestLogger.SessionData(sessionId));
        if (this.liveSessions.size() > this.peakSessions.get()) {
            this.peakSessions.set(this.liveSessions.size());
        }
        this.totalCreatedSessions.incrementAndGet();
    }

    @Override
    public void sessionDestroyed(String sessionId) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestLogger.SessionData sessionData = this.liveSessions.remove(sessionId);
        if (requestCycle != null) {
            requestCycle.setMetaData(SESSION_DATA, sessionData);
        }
    }

    protected IRequestLogger.RequestData getCurrentRequest() {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestLogger.RequestData rd = requestCycle.getMetaData(REQUEST_DATA);
        if (rd == null) {
            rd = new IRequestLogger.RequestData();
            requestCycle.setMetaData(REQUEST_DATA, rd);
            int activeCount = this.activeRequests.incrementAndGet();
            if (activeCount > this.peakActiveRequests.get()) {
                this.peakActiveRequests.set(activeCount);
            }
        }
        return rd;
    }

    @Override
    public void performLogging() {
        IRequestLogger.RequestData requestdata = RequestCycle.get().getMetaData(REQUEST_DATA);
        IRequestLogger.SessionData sessiondata = RequestCycle.get().getMetaData(SESSION_DATA);
        if (requestdata != null) {
            this.log(requestdata, sessiondata);
        }
    }

    protected abstract void log(IRequestLogger.RequestData var1, IRequestLogger.SessionData var2);

    private Object getSessionInfo(Session session) {
        if (session instanceof IRequestLogger.ISessionLogInfo) {
            return ((IRequestLogger.ISessionLogInfo)((Object)session)).getSessionInfo();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequest(IRequestLogger.RequestData rd) {
        this.resizeBuffer();
        IRequestLogger.RequestData[] requestDataArray = this.requestWindow;
        synchronized (this.requestWindow) {
            if (this.requestWindow.length == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            IRequestLogger.RequestData old = this.requestWindow[this.indexInWindow];
            this.requestWindow[this.indexInWindow] = rd;
            this.indexInWindow = (this.indexInWindow + 1) % this.requestWindow.length;
            if (old != null) {
                this.startTimeOfOldestRequest = this.requestWindow[this.indexInWindow].getStartDate();
                this.totalRequestTime -= old.getTimeTaken().longValue();
            } else if (this.startTimeOfOldestRequest == null) {
                this.startTimeOfOldestRequest = rd.getStartDate();
            }
            this.totalRequestTime += rd.getTimeTaken().longValue();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWindowSize() {
        IRequestLogger.RequestData[] requestDataArray = this.requestWindow;
        synchronized (this.requestWindow) {
            if (this.requestWindow[this.requestWindow.length - 1] == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.indexInWindow;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.requestWindow.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAverageRequestTime() {
        IRequestLogger.RequestData[] requestDataArray = this.requestWindow;
        synchronized (this.requestWindow) {
            int windowSize = this.getWindowSize();
            if (windowSize == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.totalRequestTime / (long)windowSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRequestsPerMinute() {
        IRequestLogger.RequestData[] requestDataArray = this.requestWindow;
        synchronized (this.requestWindow) {
            int windowSize = this.getWindowSize();
            if (windowSize == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0L;
            }
            long start = this.startTimeOfOldestRequest.getTime();
            long end = System.currentTimeMillis();
            double diff = end - start;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Math.round((double)windowSize / (diff / 60000.0));
        }
    }

    @Override
    public void logEventTarget(IRequestHandler requestHandler) {
        IRequestLogger.RequestData requestData = this.getCurrentRequest();
        if (requestData != null) {
            requestData.setEventTarget(requestHandler);
        }
    }

    @Override
    public void logRequestedUrl(String url) {
        this.getCurrentRequest().setRequestedUrl(url);
    }

    @Override
    public void logResponseTarget(IRequestHandler requestHandler) {
        IRequestLogger.RequestData requestData = this.getCurrentRequest();
        if (requestData != null) {
            requestData.setResponseTarget(requestHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeBuffer() {
        int newCapacity = Application.get().getRequestLoggerSettings().getRequestsWindowSize();
        if (newCapacity == this.requestWindow.length) {
            return;
        }
        IRequestLogger.RequestData[] newRequestWindow = new IRequestLogger.RequestData[newCapacity];
        IRequestLogger.RequestData[] requestDataArray = this.requestWindow;
        synchronized (this.requestWindow) {
            int oldNumberOfElements;
            int oldCapacity = this.requestWindow.length;
            int n = oldNumberOfElements = this.hasBufferRolledOver() ? oldCapacity : this.indexInWindow;
            if (newCapacity > oldCapacity) {
                this.copyRequestsInOrder(newRequestWindow);
                this.indexInWindow = oldNumberOfElements;
                this.requestWindow = newRequestWindow;
            } else if (newCapacity < oldCapacity) {
                IRequestLogger.RequestData[] sortedRequestWindow = new IRequestLogger.RequestData[oldCapacity];
                this.copyRequestsInOrder(sortedRequestWindow);
                int numberOfElementsToCopy = Math.min(newCapacity, oldNumberOfElements);
                int numberOfElementsToSkip = Math.max(0, oldNumberOfElements - numberOfElementsToCopy);
                System.arraycopy(sortedRequestWindow, numberOfElementsToSkip, newRequestWindow, 0, numberOfElementsToCopy);
                this.indexInWindow = numberOfElementsToCopy >= newCapacity ? 0 : numberOfElementsToCopy;
                this.requestWindow = newRequestWindow;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected final String formatDate(Date date) {
        Args.notNull((Object)date, (String)"date");
        Calendar cal = Calendar.getInstance(Time.GMT);
        StringBuilder buf = new StringBuilder(32);
        cal.setTimeInMillis(date.getTime());
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        int millis = cal.get(14);
        buf.append(year);
        buf.append('-');
        buf.append(String.format("%02d", month));
        buf.append('-');
        buf.append(String.format("%02d", day));
        buf.append(' ');
        buf.append(String.format("%02d", hours));
        buf.append(':');
        buf.append(String.format("%02d", minutes));
        buf.append(':');
        buf.append(String.format("%02d", seconds));
        buf.append(',');
        buf.append(String.format("%03d", millis));
        return buf.toString();
    }
}

