/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.internal.InlineEnclosure;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class AjaxEnclosureListener
implements AjaxRequestTarget.IListener {
    @Override
    public void onBeforeRespond(Map<String, Component> map, final AjaxRequestTarget target) {
        final List<Component> originalComponents = Collections.unmodifiableList(new ArrayList<Component>(map.values()));
        target.getPage().visitChildren(InlineEnclosure.class, new IVisitor<InlineEnclosure, Void>(){

            public void component(InlineEnclosure enclosure, IVisit<Void> visit) {
                for (Component component : originalComponents) {
                    if (!AjaxEnclosureListener.this.isControllerOfEnclosure(component, enclosure)) continue;
                    enclosure.updateVisibility();
                    target.add(enclosure);
                }
            }
        });
    }

    private boolean isControllerOfEnclosure(Component component, InlineEnclosure enclosure) {
        return enclosure.getParent().get(enclosure.getChildId()) == component;
    }

    @Override
    public void onAfterRespond(Map<String, Component> map, AjaxRequestTarget.IJavaScriptResponse response) {
    }
}

