/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.scheduler.internal;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.jabylon.common.progress.Progression;
import org.jabylon.scheduler.JobExecution;
import org.jabylon.scheduler.JobInstance;
import org.jabylon.scheduler.internal.ProgressionImpl;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabylonJob
implements InterruptableJob,
JobInstance {
    private static final int MAX_RETRIES = 5;
    private static final String KEY_RETRY_COUNT = "count";
    private Thread thread;
    private ProgressionImpl monitor;
    private JobExecutionContext context;
    public static final String CONNECTOR_KEY = "repository.connector";
    public static final String EXECUTION_KEY = "execution";
    public static final String DOMAIN_OBJECT_KEY = "domain";
    public static final String PROGRESS_MONITOR = "monitor";
    private static final Logger LOG = LoggerFactory.getLogger(JabylonJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        int count;
        this.context = context;
        this.thread = Thread.currentThread();
        long time = System.currentTimeMillis();
        JobDataMap dataMap = context.getMergedJobDataMap();
        JobExecution runnable = this.getExecutionObject();
        if (!dataMap.containsKey((Object)KEY_RETRY_COUNT)) {
            dataMap.put(KEY_RETRY_COUNT, 0);
        }
        if ((count = dataMap.getIntValue(KEY_RETRY_COUNT)) >= 5) {
            JobExecutionException e = new JobExecutionException("Retries exceeded");
            LOG.error("Job " + runnable + " failed 5 times in a row. Deactivating");
            e.setUnscheduleAllTriggers(true);
            throw e;
        }
        if (runnable == null) {
            throw new IllegalStateException("No Job Execution was found");
        }
        try {
            this.monitor = new ProgressionImpl();
            context.setResult((Object)this.monitor);
            runnable.run(this.monitor, context.getMergedJobDataMap().getWrappedMap());
            LOG.info("Job {} finished in {}ms", (Object)runnable, (Object)(System.currentTimeMillis() - time));
            dataMap.put(KEY_RETRY_COUNT, 0);
        }
        catch (OperationCanceledException e) {
            this.monitor.setStatus((IStatus)new Status(8, "org.jabylon.common", null, (Throwable)e));
        }
        catch (Exception e) {
            dataMap.put(KEY_RETRY_COUNT, count);
            if (runnable.retryOnError()) {
                try {
                    ++count;
                    LOG.warn("Job {} failed. Retrying after 1 minute");
                    Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
            this.monitor.setStatus((IStatus)new Status(4, "org.jabylon.common", null, (Throwable)e));
            throw new JobExecutionException((Throwable)e, runnable.retryOnError());
        }
        finally {
            this.thread = null;
            if (this.monitor.isCanceled() && this.monitor.getStatus() != null) {
                IStatus status = this.monitor.getStatus();
                Status newStatus = new Status(8, status.getPlugin(), status.getMessage());
                this.monitor.setStatus((IStatus)newStatus);
            }
            this.log(this.monitor.getStatus());
            if (!runnable.retryOnError() || count >= 5) {
                this.monitor.done();
            }
        }
    }

    private void log(IStatus status) {
        int severity = status.getSeverity();
        switch (severity) {
            case 0: {
                LOG.debug("finished job {} : {}", (Object)this.getID(), (Object)status.getMessage());
                break;
            }
            case 8: {
                LOG.debug("canceled job " + this.getID() + " : " + status.getMessage(), status.getException());
                break;
            }
            case 2: {
                LOG.warn("job " + this.getID() + " finished with warning: " + status.getMessage(), status.getException());
                break;
            }
            case 4: {
                LOG.error("job " + this.getID() + " failed: " + status.getMessage(), status.getException());
                break;
            }
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        if (this.monitor != null) {
            this.monitor.setCanceled(true);
        }
    }

    @Override
    public String getID() {
        return this.context.getJobDetail().getKey().getName();
    }

    @Override
    public Progression getProgress() {
        return this.monitor;
    }

    @Override
    public <T> T getDomainObject() {
        JobDataMap dataMap = this.context.getMergedJobDataMap();
        return (T)dataMap.get((Object)DOMAIN_OBJECT_KEY);
    }

    @Override
    public String getDescription() {
        return this.context.getJobDetail().getDescription();
    }

    @Override
    public JobExecution getExecutionObject() {
        return (JobExecution)this.context.getMergedJobDataMap().get((Object)EXECUTION_KEY);
    }
}

