/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.scheduler.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.common.progress.ProgressService;
import org.jabylon.common.progress.Progression;
import org.jabylon.common.progress.RunnableWithProgress;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.common.util.AttachablePreferences;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.scheduler.JobExecution;
import org.jabylon.scheduler.JobInstance;
import org.jabylon.scheduler.ScheduleServiceException;
import org.jabylon.scheduler.SchedulerService;
import org.jabylon.scheduler.internal.JabylonJob;
import org.jabylon.scheduler.internal.ProgressionImpl;
import org.jabylon.scheduler.internal.RunnableWithProgressWrapper;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service(value={ProgressService.class, SchedulerService.class})
public class JobRegistry
implements IEclipsePreferences.INodeChangeListener,
IEclipsePreferences.IPreferenceChangeListener,
SchedulerService,
ProgressService {
    private Scheduler scheduler;
    public static final String PLUGIN_ID = "org.jabylon.scheduler";
    private static final Logger logger = LoggerFactory.getLogger(JobRegistry.class);
    private AtomicLong oneTimeJobs = new AtomicLong();
    @Reference
    private RepositoryConnector repositoryConnector;
    @Reference
    private URIResolver uriResolver;
    @Reference(referenceInterface=JobExecution.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindJob", unbind="unbindJob")
    private Map<String, JobExecution> jobDefinitions = new ConcurrentHashMap<String, JobExecution>();
    private Map<String, Preferences> jobInstances = new ConcurrentHashMap<String, Preferences>();

    public void bindUriResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public void unbindUriResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public void bindRepositoryConnector(RepositoryConnector connector) {
        this.repositoryConnector = connector;
    }

    public void unbindRepositoryConnector(RepositoryConnector connector) {
        this.repositoryConnector = null;
    }

    public void bindJob(JobExecution execution, Map<String, Object> properties) {
        Preferences prefs = PreferencesUtil.getNodeForJob((Preferences)PreferencesUtil.workspaceScope(), (String)execution.getID());
        Preferences defaultPrefs = this.defaultsFor(execution.getID());
        this.jobDefinitions.put(execution.getID(), execution);
        Set<Map.Entry<String, Object>> entrySet = properties.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            defaultPrefs.put(entry.getKey(), entry.getValue().toString());
        }
        try {
            this.updateJob(prefs);
        }
        catch (SchedulerException e) {
            logger.error("Failed to schedule job " + execution, (Throwable)e);
        }
    }

    public void unbindJob(JobExecution execution) {
        Iterator<Map.Entry<String, Preferences>> iterator = this.jobInstances.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Preferences> entry = iterator.next();
            Preferences value = entry.getValue();
            if (!execution.getID().equals(value.name())) continue;
            iterator.remove();
            this.removeJob(value.absolutePath());
        }
        AttachablePreferences prefs = new AttachablePreferences(PreferencesUtil.workspaceScope().node("jobs"), execution.getID());
        this.jobDefinitions.remove(execution.getID());
        this.removeJob(prefs.absolutePath());
    }

    @Activate
    public void activate() throws SchedulerException {
        StdSchedulerFactory schedFact = new StdSchedulerFactory();
        this.scheduler = schedFact.getScheduler();
        this.scheduler.start();
        this.absorbNode(PreferencesUtil.rootScope());
        for (Preferences jobDefinition : this.jobInstances.values()) {
            this.updateJob(jobDefinition);
        }
    }

    public void updateJob(Preferences node) throws SchedulerException {
        this.jobInstances.put(node.absolutePath(), node);
        if (this.scheduler == null) {
            return;
        }
        String jobID = node.absolutePath();
        Preferences defaults = this.defaultsFor(node.name());
        boolean active = node.getBoolean("active", defaults.getBoolean("active", false));
        CronTrigger trigger = null;
        try {
            trigger = this.createSchedule(jobID, node);
        }
        catch (Exception e) {
            logger.error("Invalid cron expression for job " + node, (Throwable)e);
        }
        this.removeJob(jobID);
        if (trigger != null && active) {
            this.scheduler.scheduleJob(this.createJobDetails(node, jobID), (Trigger)trigger);
        }
    }

    protected Preferences defaultsFor(String jobID) {
        IEclipsePreferences defaultPrefs = DefaultScope.INSTANCE.getNode(PLUGIN_ID);
        return defaultPrefs.node(jobID);
    }

    private CronTrigger createSchedule(String jobID, Preferences prefs) {
        Preferences defaults = this.defaultsFor(prefs.name());
        String cron = prefs.get("schedule", defaults.get("schedule", null));
        if (cron == null || cron.trim().isEmpty()) {
            return null;
        }
        return (CronTrigger)TriggerBuilder.newTrigger().forJob(prefs.absolutePath()).withIdentity(prefs.absolutePath()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
    }

    private JobDetail createJobDetails(Preferences element, String jobID) {
        Preferences defaults = this.defaultsFor(element.name());
        JobBuilder builder = JobBuilder.newJob(JabylonJob.class).withIdentity(element.absolutePath()).withDescription(element.get("description", defaults.get("description", null))).storeDurably(true);
        try {
            String[] keys;
            for (String string : keys = element.keys()) {
                builder.usingJobData(string, element.get(string, defaults.get(string, null)));
            }
        }
        catch (BackingStoreException e) {
            logger.error("Failed to retrieve properties of node " + element, (Throwable)e);
        }
        JobDataMap extras = new JobDataMap();
        extras.put("repository.connector", (Object)this.repositoryConnector);
        extras.put("execution", (Object)this.jobDefinitions.get(element.name()));
        extras.put("domain", this.getDomainObject(element));
        builder.usingJobData(extras);
        return builder.build();
    }

    private JobDetail createOneShotJobDetails(RunnableWithProgress task, String id, String description) {
        JobBuilder builder = JobBuilder.newJob(JabylonJob.class).withIdentity(new JobKey(id)).withDescription(description);
        JobDataMap extras = new JobDataMap();
        extras.put("execution", (Object)new RunnableWithProgressWrapper(task, this.getScheduler(), id));
        builder.usingJobData(extras);
        return builder.build();
    }

    private Object getDomainObject(Preferences jobConfig) {
        Preferences domainPrefs = jobConfig.parent().parent();
        String domainPath = domainPrefs.absolutePath();
        String prefix = InstanceScope.INSTANCE.getNode("org.jabylon.common/config").absolutePath();
        String path = domainPath.substring(prefix.length(), domainPath.length());
        return this.uriResolver.resolve(path);
    }

    @Deactivate
    public void deactivate() throws SchedulerException {
        this.scheduler.shutdown(true);
        this.jobDefinitions.clear();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.hasChange(event)) {
            if (event.getKey().equals("active") && Boolean.FALSE.equals(event.getNewValue())) {
                this.removeJob(event.getNode().absolutePath());
            }
            try {
                this.updateJob(event.getNode());
            }
            catch (SchedulerException e) {
                logger.error("Failed to update job " + event.getNode().absolutePath(), (Throwable)e);
            }
        }
    }

    private boolean hasChange(IEclipsePreferences.PreferenceChangeEvent event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue != null) {
            return !oldValue.equals(newValue);
        }
        return oldValue != newValue;
    }

    public void added(IEclipsePreferences.NodeChangeEvent event) {
        Preferences child = event.getChild();
        try {
            this.absorbNode(child);
        }
        catch (SchedulerException e) {
            logger.error("Failed to absorb node " + child, (Throwable)e);
        }
    }

    protected void absorbNode(Preferences prefs) throws SchedulerException {
        IEclipsePreferences node = this.toEclipsePreferences(prefs);
        if (node.parent().name().equals("jobs")) {
            this.updateJob((Preferences)node);
            node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        } else {
            node.addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            try {
                String[] children;
                for (String child : children = node.childrenNames()) {
                    this.absorbNode(node.node(child));
                }
            }
            catch (BackingStoreException e) {
                logger.error("Failed to absorb node " + node, (Throwable)e);
            }
        }
    }

    public void removed(IEclipsePreferences.NodeChangeEvent event) {
        Preferences child = event.getChild();
        String jobID = child.name();
        this.removeJob(jobID);
    }

    protected void removeJob(String jobID) {
        if (this.scheduler == null) {
            return;
        }
        JobKey triggerKey = new JobKey(jobID);
        try {
            if (this.scheduler.isStarted() && !this.scheduler.isShutdown() && this.scheduler.checkExists(triggerKey)) {
                this.scheduler.deleteJob(triggerKey);
            }
        }
        catch (SchedulerException e) {
            logger.error("Failed to delete job " + jobID, (Throwable)e);
        }
    }

    protected IEclipsePreferences toEclipsePreferences(Preferences node) {
        if (node instanceof IEclipsePreferences) {
            IEclipsePreferences pref = (IEclipsePreferences)node;
            return pref;
        }
        return null;
    }

    @Override
    public Date nextExecution(Preferences jobConfig) throws ScheduleServiceException {
        return this.nextExecution(jobConfig.absolutePath());
    }

    @Override
    public Date nextExecution(String jobID) throws ScheduleServiceException {
        Preferences settings = this.jobInstances.get(jobID);
        Preferences defaults = this.defaultsFor(jobID.substring(jobID.lastIndexOf("/") + 1));
        if (settings != null && settings.getBoolean("active", defaults.getBoolean("active", false))) {
            try {
                Trigger trigger = this.scheduler.getTrigger(new TriggerKey(jobID));
                if (trigger != null) {
                    return trigger.getNextFireTime();
                }
            }
            catch (SchedulerException e) {
                throw new ScheduleServiceException(e);
            }
        }
        return null;
    }

    @Override
    public List<JobInstance> getRunningJobs() throws ScheduleServiceException {
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        try {
            List jobs = this.scheduler.getCurrentlyExecutingJobs();
            for (JobExecutionContext context : jobs) {
                Job instance = context.getJobInstance();
                if (!(instance instanceof JobInstance)) continue;
                JobInstance jobInstance = (JobInstance)instance;
                jobInstances.add(jobInstance);
            }
        }
        catch (Exception e) {
            throw new ScheduleServiceException(e);
        }
        return jobInstances;
    }

    @Override
    public void trigger(Preferences jobConfig) throws ScheduleServiceException {
        try {
            this.scheduler.triggerJob(new JobKey(jobConfig.absolutePath()));
        }
        catch (SchedulerException e) {
            throw new ScheduleServiceException(e);
        }
    }

    public String schedule(RunnableWithProgress task, String description) {
        long id = this.oneTimeJobs.getAndIncrement();
        try {
            this.scheduler.scheduleJob(this.createOneShotJobDetails(task, Long.toString(id), description), TriggerBuilder.newTrigger().startNow().build());
        }
        catch (SchedulerException e) {
            throw new RuntimeException("failed to schedule task", e);
        }
        return Long.toString(id);
    }

    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (SchedulerException e) {
            logger.error("Shutdown failed", (Throwable)e);
        }
    }

    public Progression progressionOf(String id) {
        try {
            JobKey key = new JobKey(id);
            JobDetail jobDetail = this.getScheduler().getJobDetail(key);
            List jobs = this.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext context : jobs) {
                if (!context.getJobDetail().getKey().equals((Object)key)) continue;
                JabylonJob job = (JabylonJob)context.getJobInstance();
                return job.getProgress();
            }
            if (jobDetail != null) {
                ProgressionImpl fakeProgression = new ProgressionImpl();
                return fakeProgression;
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Failed to retrieve progression for id " + id, e);
        }
        return null;
    }

    public void cancel(String id) {
        try {
            JobKey key = new JobKey(id);
            List jobs = this.getScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext context : jobs) {
                if (!context.getJobDetail().getKey().equals((Object)key)) continue;
                JabylonJob job = (JabylonJob)context.getJobInstance();
                job.interrupt();
            }
            this.getScheduler().deleteJob(key);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Failed to retrieve progression for id " + id, e);
        }
    }
}

