/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import org.eclipse.emf.cdo.internal.net4j.RecoveringCDOSessionImpl;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.IConnector;

public class ReconnectingCDOSessionImpl
extends RecoveringCDOSessionImpl {
    private long reconnectInterval = 0L;
    private int maxReconnectAttempts = Integer.MAX_VALUE;

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public void setConnector(IConnector connector) {
    }

    public void setRepositoryConnectorDescription(String description) {
        if (this.getRepositoryConnectorDescription() != null) {
            throw new IllegalStateException("Don't call setRepositoryConnectorDescription more than once");
        }
        super.setRepositoryConnectorDescription(description);
    }

    protected void updateConnectorAndRepositoryName() {
        this.removeTCPConnector();
        IConnector newConnector = null;
        int failedAttempts = 0;
        long startOfLastAttempt = 0L;
        while (newConnector == null && failedAttempts < this.maxReconnectAttempts) {
            try {
                if (startOfLastAttempt > 0L) {
                    this.delayAsNeeded(startOfLastAttempt);
                }
                startOfLastAttempt = System.currentTimeMillis();
                newConnector = this.createTCPConnector(this.getUseHeartBeat());
            }
            catch (ConnectorException ex) {
                ++failedAttempts;
            }
        }
        if (newConnector == null) {
            throw new RuntimeException("Recovery failed");
        }
        super.setConnector(newConnector);
    }

    private void delayAsNeeded(long startOfLastAttempt) {
        long timeToWait = this.requiredDelay(startOfLastAttempt);
        while (timeToWait > 0L) {
            try {
                Thread.sleep(timeToWait);
                timeToWait = 0L;
            }
            catch (InterruptedException ex) {
                timeToWait = this.requiredDelay(startOfLastAttempt);
            }
        }
    }

    private long requiredDelay(long startOfLastAttempt) {
        long now = System.currentTimeMillis();
        long timeSinceLastAttempt = now - startOfLastAttempt;
        long timeToWait = this.reconnectInterval - timeSinceLastAttempt;
        return timeToWait;
    }
}

