/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.DiffieHellman;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationIndication
extends IndicationWithMonitoring {
    private DiffieHellman.Server.Challenge challenge;

    public AuthenticationIndication(SignalProtocol<?> protocol) {
        super(protocol, (short)2);
    }

    public CDOClientProtocol getProtocol() {
        return (CDOClientProtocol)super.getProtocol();
    }

    protected InternalCDOSession getSession() {
        return (InternalCDOSession)this.getProtocol().getSession();
    }

    protected void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        this.challenge = new DiffieHellman.Server.Challenge((ExtendedDataInput)in);
    }

    protected void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                IPasswordCredentialsProvider credentialsProvider = this.getSession().getCredentialsProvider();
                if (credentialsProvider == null) {
                    throw new IllegalStateException("No credentials provider configured");
                }
                IPasswordCredentials credentials = credentialsProvider.getCredentials();
                if (credentials == null) {
                    throw new IllegalStateException("No credentials provided");
                }
                String userID = credentials.getUserID();
                if (StringUtil.isEmpty((String)userID)) {
                    throw new IllegalStateException("No userID provided");
                }
                String password = new String(credentials.getPassword());
                if (StringUtil.isEmpty((String)userID)) {
                    throw new IllegalStateException("No password provided");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ExtendedDataOutputStream stream = new ExtendedDataOutputStream((OutputStream)baos);
                stream.writeString(userID);
                stream.writeString(password);
                stream.flush();
                byte[] clearText = baos.toByteArray();
                DiffieHellman.Client client = new DiffieHellman.Client();
                DiffieHellman.Client.Response response = client.handleChallenge(this.challenge, clearText);
                out.writeBoolean(true);
                response.write((ExtendedDataOutput)out);
            }
            catch (Throwable ex) {
                out.writeBoolean(false);
                OM.LOG.error(ex);
                async.stop();
                monitor.done();
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }
}

