/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Severity implements Enumerator
{
    INFO(0, "INFO", "INFO"),
    WARNING(1, "WARNING", "WARNING"),
    ERROR(2, "ERROR", "ERROR");

    public static final int INFO_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int ERROR_VALUE = 2;
    private static final Severity[] VALUES_ARRAY;
    public static final List<Severity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Severity get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Severity result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Severity getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Severity result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Severity get(int value) {
        switch (value) {
            case 0: {
                return INFO;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return ERROR;
            }
        }
        return null;
    }

    private Severity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Severity[]{INFO, WARNING, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

