/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.impl;

import java.io.File;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.properties.DiffKind;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.ScanConfiguration;
import org.jabylon.properties.impl.ResolvableImpl;
import org.jabylon.properties.types.PropertyScanner;
import org.jabylon.properties.util.PropertyResourceUtil;
import org.jabylon.properties.util.scanner.FullScanFileAcceptor;
import org.jabylon.properties.util.scanner.PartialScanFileAcceptor;
import org.jabylon.properties.util.scanner.WorkspaceScanner;

public class ProjectVersionImpl
extends ResolvableImpl<Project, ProjectLocale>
implements ProjectVersion {
    protected static final boolean READ_ONLY_EDEFAULT = false;

    protected ProjectVersionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PropertiesPackage.Literals.PROJECT_VERSION;
    }

    @Override
    public NotificationChain basicSetParent(Project newParent, NotificationChain msgs) {
        return super.basicSetParent(newParent, msgs);
    }

    @Override
    public ProjectLocale getTemplate() {
        return (ProjectLocale)this.eDynamicGet(4, (EStructuralFeature)PropertiesPackage.Literals.PROJECT_VERSION__TEMPLATE, true, true);
    }

    public ProjectLocale basicGetTemplate() {
        return (ProjectLocale)this.eDynamicGet(4, (EStructuralFeature)PropertiesPackage.Literals.PROJECT_VERSION__TEMPLATE, false, true);
    }

    @Override
    public void setTemplate(ProjectLocale newTemplate) {
        this.eDynamicSet(4, (EStructuralFeature)PropertiesPackage.Literals.PROJECT_VERSION__TEMPLATE, newTemplate);
    }

    @Override
    public boolean isReadOnly() {
        return (Boolean)this.eDynamicGet(5, (EStructuralFeature)PropertiesPackage.Literals.PROJECT_VERSION__READ_ONLY, true, true);
    }

    @Override
    public void setReadOnly(boolean newReadOnly) {
        this.eDynamicSet(5, (EStructuralFeature)PropertiesPackage.Literals.PROJECT_VERSION__READ_ONLY, newReadOnly);
    }

    public Project getProject() {
        return (Project)this.eContainer();
    }

    @Override
    public void fullScan(ScanConfiguration configuration) {
        this.fullScan(configuration, null);
    }

    @Override
    public void fullScan(ScanConfiguration configuration, IProgressMonitor monitor) {
        this.getChildren().clear();
        this.setTemplate(null);
        WorkspaceScanner scanner = new WorkspaceScanner();
        File baseDir = new File(this.absolutPath().path()).getAbsoluteFile();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Scanning", (int)100);
        PropertyScanner propertyScanner = PropertyResourceUtil.createScanner(this);
        scanner.fullScan(new FullScanFileAcceptor(this, propertyScanner, configuration), baseDir, propertyScanner, configuration, (IProgressMonitor)subMonitor.newChild(50));
        for (ProjectLocale projectLocale : this.getChildren()) {
            for (PropertyFileDescriptor descriptor : projectLocale.getDescriptors()) {
                descriptor.updatePercentComplete();
            }
        }
        PropertyResourceUtil.createMissingDescriptorEntries(this, (IProgressMonitor)subMonitor.newChild(50));
    }

    @Override
    public ProjectLocale getProjectLocale(Locale locale) {
        EList locales = this.getChildren();
        for (ProjectLocale projectLocale : locales) {
            if (!locale.equals(projectLocale.getLocale())) continue;
            return projectLocale;
        }
        return null;
    }

    @Override
    public void partialScan(ScanConfiguration configuration, PropertyFileDiff fileDiff) {
        String filePath;
        File singleFile;
        PropertyScanner propertyScanner = PropertyResourceUtil.createScanner(this);
        WorkspaceScanner scanner = new WorkspaceScanner();
        File baseDir = new File(this.absolutPath().path()).getAbsoluteFile();
        if (!scanner.partialScan(baseDir, propertyScanner, configuration, singleFile = new File(baseDir, filePath = fileDiff.getKind() == DiffKind.REMOVE ? fileDiff.getOldPath() : fileDiff.getNewPath()))) {
            return;
        }
        switch (fileDiff.getKind()) {
            case MOVE: {
                this.deleteDescriptor(this.makeURI(fileDiff.getOldPath()));
            }
            case COPY: 
            case ADD: {
                scanner.partialScan(new PartialScanFileAcceptor(this, propertyScanner, configuration), baseDir, propertyScanner, configuration, singleFile);
                break;
            }
            case MODIFY: {
                PropertyFileDescriptor descriptor = this.findDescriptor(this.makeURI(fileDiff.getNewPath()));
                if (descriptor == null) break;
                PropertyFile properties = descriptor.loadProperties();
                descriptor.setKeys(properties.getProperties().size());
                descriptor.updatePercentComplete();
                if (!descriptor.isMaster()) break;
                EList<PropertyFileDescriptor> descriptors = descriptor.getDerivedDescriptors();
                for (PropertyFileDescriptor child : descriptors) {
                    child.updatePercentComplete();
                }
                break;
            }
            case REMOVE: {
                this.deleteDescriptor(this.makeURI(fileDiff.getOldPath()));
            }
        }
    }

    private URI makeURI(String diffPath) {
        String path = diffPath.replace('\\', '/');
        if (diffPath.startsWith("/")) {
            return URI.createURI((String)diffPath);
        }
        return URI.createURI((String)("/" + path));
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                if (resolve) {
                    return this.getTemplate();
                }
                return this.basicGetTemplate();
            }
            case 5: {
                return this.isReadOnly();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setTemplate((ProjectLocale)newValue);
                return;
            }
            case 5: {
                this.setReadOnly((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setTemplate(null);
                return;
            }
            case 5: {
                this.setReadOnly(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.basicGetTemplate() != null;
            }
            case 5: {
                return this.isReadOnly();
            }
        }
        return super.eIsSet(featureID);
    }

    private void deleteDescriptor(URI uri) {
        PropertyFileDescriptor descriptor = this.findDescriptor(uri);
        if (descriptor != null) {
            PropertyResourceUtil.removeDescriptor(descriptor);
        }
    }

    @Override
    public Resolvable resolveChild(URI path) {
        if (path.segmentCount() == 0 || this.relativePath().equals(path)) {
            return this;
        }
        String localeSegment = path.segment(0);
        ProjectLocale projectLocale = null;
        if (localeSegment.equals("template")) {
            projectLocale = this.getTemplate();
        } else {
            Locale locale = (Locale)PropertiesFactory.eINSTANCE.createFromString(PropertiesPackage.Literals.LOCALE, localeSegment);
            if (locale == null) {
                return null;
            }
            projectLocale = this.getProjectLocale(locale);
        }
        if (path.segmentCount() == 1) {
            return projectLocale;
        }
        String[] segments = path.segments();
        String[] remainder = new String[segments.length - 1];
        System.arraycopy(segments, 1, remainder, 0, remainder.length);
        URI shorterURI = URI.createHierarchicalURI((String[])remainder, null, null);
        return projectLocale.resolveChild(shorterURI);
    }

    protected PropertyFileDescriptor findDescriptor(URI path) {
        ProjectLocale locale;
        PropertyScanner scanner = PropertyResourceUtil.createScanner(this);
        Locale variant = scanner.getLocale(new File(path.path()));
        ProjectLocale projectLocale = locale = variant == null ? this.getTemplate() : this.getProjectLocale(variant);
        if (locale == null) {
            return null;
        }
        EList<PropertyFileDescriptor> descriptors = locale.getDescriptors();
        for (PropertyFileDescriptor descriptor : descriptors) {
            if (!path.equals(descriptor.getLocation())) continue;
            return descriptor;
        }
        return null;
    }

    private Locale createVariant(String localeString) {
        return (Locale)PropertiesFactory.eINSTANCE.createFromString(PropertiesPackage.Literals.LOCALE, localeString);
    }
}

