/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.jabylon.properties.Comment;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.Review;
import org.jabylon.properties.impl.ResolvableImpl;
import org.jabylon.properties.util.PropertiesResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileDescriptorImpl
extends ResolvableImpl<Resolvable<?, ?>, PropertyFileDescriptor>
implements PropertyFileDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileDescriptorImpl.class);
    protected static final Locale VARIANT_EDEFAULT = null;
    protected static final URI LOCATION_EDEFAULT = null;
    protected static final int KEYS_EDEFAULT = 0;
    protected static final long LAST_MODIFIED_EDEFAULT = 0L;

    protected PropertyFileDescriptorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR;
    }

    @Override
    public Locale getVariant() {
        return (Locale)this.eDynamicGet(4, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__VARIANT, true, true);
    }

    @Override
    public void setVariant(Locale newVariant) {
        this.eDynamicSet(4, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__VARIANT, newVariant);
    }

    @Override
    public URI getLocation() {
        return (URI)this.eDynamicGet(5, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__LOCATION, true, true);
    }

    @Override
    public void setLocation(URI newLocation) {
        this.eDynamicSet(5, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__LOCATION, newLocation);
    }

    @Override
    public boolean isMaster() {
        ProjectLocale locale = this.getProjectLocale();
        if (locale == null) {
            return false;
        }
        return locale.isMaster();
    }

    @Override
    public PropertyFile loadProperties() {
        URI path = this.absolutPath();
        PropertiesResourceImpl resource = new PropertiesResourceImpl(path);
        HashMap<String, String> options = new HashMap<String, String>();
        if (this.getProjectLocale() != null && this.getProjectLocale().getParent() != null && ((ProjectVersion)this.getProjectLocale().getParent()).getParent() != null) {
            options.put("file.mode", ((Project)((ProjectVersion)this.getProjectLocale().getParent()).getParent()).getPropertyType());
        }
        try {
            resource.load(options);
        }
        catch (FileNotFoundException e) {
            logger.debug("Tried to load non-existing property file. Path: {}", (Object)path.path());
            return PropertiesFactory.eINSTANCE.createPropertyFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (PropertyFile)resource.getContents().get(0);
    }

    @Override
    public PropertyFile loadProperties(InputStream in) {
        URI path = this.absolutPath();
        PropertiesResourceImpl resource = new PropertiesResourceImpl(path);
        HashMap<String, String> options = new HashMap<String, String>();
        if (this.getProjectLocale() != null && this.getProjectLocale().getParent() != null && ((ProjectVersion)this.getProjectLocale().getParent()).getParent() != null) {
            options.put("file.mode", ((Project)((ProjectVersion)this.getProjectLocale().getParent()).getParent()).getPropertyType());
        }
        try {
            resource.load(in, options);
        }
        catch (FileNotFoundException e) {
            PropertyFile propertyFile = PropertiesFactory.eINSTANCE.createPropertyFile();
            return propertyFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (PropertyFile)resource.getContents().get(0);
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                PropertyFileDescriptor master = this.getMaster();
                if (master != null) {
                    msgs = ((InternalEObject)master).eInverseRemove((InternalEObject)this, 12, PropertyFileDescriptor.class, msgs);
                }
                return this.basicSetMaster((PropertyFileDescriptor)otherEnd, msgs);
            }
            case 7: {
                ProjectLocale projectLocale = this.getProjectLocale();
                if (projectLocale != null) {
                    msgs = ((InternalEObject)projectLocale).eInverseRemove((InternalEObject)this, 5, ProjectLocale.class, msgs);
                }
                return this.basicSetProjectLocale((ProjectLocale)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getDerivedDescriptors()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return this.basicSetMaster(null, msgs);
            }
            case 7: {
                return this.basicSetProjectLocale(null, msgs);
            }
            case 9: {
                return ((InternalEList)this.getReviews()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getDerivedDescriptors()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public PropertyFileDescriptor getMaster() {
        return (PropertyFileDescriptor)this.eDynamicGet(6, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__MASTER, true, true);
    }

    public NotificationChain basicSetMaster(PropertyFileDescriptor newMaster, NotificationChain msgs) {
        msgs = this.eDynamicInverseAdd((InternalEObject)newMaster, 6, msgs);
        return msgs;
    }

    @Override
    public void setMaster(PropertyFileDescriptor newMaster) {
        this.eDynamicSet(6, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__MASTER, newMaster);
    }

    @Override
    public ProjectLocale getProjectLocale() {
        return (ProjectLocale)this.eDynamicGet(7, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__PROJECT_LOCALE, true, true);
    }

    public NotificationChain basicSetProjectLocale(ProjectLocale newProjectLocale, NotificationChain msgs) {
        msgs = this.eDynamicInverseAdd((InternalEObject)newProjectLocale, 7, msgs);
        return msgs;
    }

    @Override
    public void setProjectLocale(ProjectLocale newProjectLocale) {
        this.eDynamicSet(7, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__PROJECT_LOCALE, newProjectLocale);
    }

    @Override
    public int getKeys() {
        return (Integer)this.eDynamicGet(8, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__KEYS, true, true);
    }

    @Override
    public void setKeys(int newKeys) {
        this.eDynamicSet(8, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__KEYS, newKeys);
    }

    @Override
    public EList<Review> getReviews() {
        return (EList)this.eDynamicGet(9, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__REVIEWS, true, true);
    }

    @Override
    public long getLastModified() {
        return (Long)this.eDynamicGet(10, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__LAST_MODIFIED, true, true);
    }

    @Override
    public void setLastModified(long newLastModified) {
        this.eDynamicSet(10, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__LAST_MODIFIED, newLastModified);
    }

    @Override
    public Comment getLastModification() {
        return (Comment)this.eDynamicGet(11, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__LAST_MODIFICATION, true, true);
    }

    @Override
    public void setLastModification(Comment newLastModification) {
        this.eDynamicSet(11, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__LAST_MODIFICATION, newLastModification);
    }

    @Override
    public EList<PropertyFileDescriptor> getDerivedDescriptors() {
        return (EList)this.eDynamicGet(12, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__DERIVED_DESCRIPTORS, true, true);
    }

    @Override
    public int internalUpdatePercentComplete() {
        if (this.isMaster()) {
            return 100;
        }
        PropertyFileDescriptor master = this.getMaster();
        int keys = master.getKeys();
        int translated = this.getKeys();
        return (int)Math.min(100.0, Math.floor((double)translated / (double)keys * 100.0));
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getVariant();
            }
            case 5: {
                return this.getLocation();
            }
            case 6: {
                return this.getMaster();
            }
            case 7: {
                return this.getProjectLocale();
            }
            case 8: {
                return this.getKeys();
            }
            case 9: {
                return this.getReviews();
            }
            case 10: {
                return this.getLastModified();
            }
            case 11: {
                return this.getLastModification();
            }
            case 12: {
                return this.getDerivedDescriptors();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setVariant((Locale)newValue);
                return;
            }
            case 5: {
                this.setLocation((URI)newValue);
                return;
            }
            case 6: {
                this.setMaster((PropertyFileDescriptor)newValue);
                return;
            }
            case 7: {
                this.setProjectLocale((ProjectLocale)newValue);
                return;
            }
            case 8: {
                this.setKeys((Integer)newValue);
                return;
            }
            case 9: {
                this.getReviews().clear();
                this.getReviews().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setLastModified((Long)newValue);
                return;
            }
            case 11: {
                this.setLastModification((Comment)newValue);
                return;
            }
            case 12: {
                this.getDerivedDescriptors().clear();
                this.getDerivedDescriptors().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setVariant(VARIANT_EDEFAULT);
                return;
            }
            case 5: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 6: {
                this.setMaster(null);
                return;
            }
            case 7: {
                this.setProjectLocale(null);
                return;
            }
            case 8: {
                this.setKeys(0);
                return;
            }
            case 9: {
                this.getReviews().clear();
                return;
            }
            case 10: {
                this.setLastModified(0L);
                return;
            }
            case 11: {
                this.setLastModification(null);
                return;
            }
            case 12: {
                this.getDerivedDescriptors().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return VARIANT_EDEFAULT == null ? this.getVariant() != null : !VARIANT_EDEFAULT.equals(this.getVariant());
            }
            case 5: {
                return LOCATION_EDEFAULT == null ? this.getLocation() != null : !LOCATION_EDEFAULT.equals(this.getLocation());
            }
            case 6: {
                return this.getMaster() != null;
            }
            case 7: {
                return this.getProjectLocale() != null;
            }
            case 8: {
                return this.getKeys() != 0;
            }
            case 9: {
                return !this.getReviews().isEmpty();
            }
            case 10: {
                return this.getLastModified() != 0L;
            }
            case 11: {
                return this.getLastModification() != null;
            }
            case 12: {
                return !this.getDerivedDescriptors().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        try {
            if (this.getLocation() != null) {
                return this.getLocation().toString();
            }
        }
        catch (Exception e) {
            logger.error("Exception during toString", (Throwable)e);
        }
        return super.toString();
    }
}

