/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyAnnotation;

public class PropertyImpl
extends CDOObjectImpl
implements Property,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern ANNOTATION_PARSER = Pattern.compile("@([\\w-]+)(\\((.*?)\\))?");
    private static final Pattern ANNOTATION_VALUE_PARSER = Pattern.compile("(\\w+)=\"(.*?)\"");
    protected static final String KEY_EDEFAULT = null;
    protected static final String VALUE_EDEFAULT = null;
    protected static final String COMMENT_EDEFAULT = null;
    protected static final String COMMENT_WITHOUT_ANNOTATIONS_EDEFAULT = null;

    protected PropertyImpl() {
    }

    protected EClass eStaticClass() {
        return PropertiesPackage.Literals.PROPERTY;
    }

    protected int eStaticFeatureCount() {
        return 0;
    }

    @Override
    public String getKey() {
        return (String)this.eDynamicGet(0, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY__KEY, true, true);
    }

    @Override
    public void setKey(String newKey) {
        this.eDynamicSet(0, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY__KEY, newKey);
    }

    @Override
    public String getValue() {
        return (String)this.eDynamicGet(1, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY__VALUE, true, true);
    }

    @Override
    public void setValue(String newValue) {
        this.eDynamicSet(1, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY__VALUE, newValue);
    }

    @Override
    public String getComment() {
        return (String)this.eDynamicGet(2, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY__COMMENT, true, true);
    }

    @Override
    public void setComment(String newComment) {
        String result = this.parseAnnotations(newComment);
        this.eDynamicSet(2, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY__COMMENT, result);
    }

    private String parseAnnotations(String string) {
        this.getAnnotations().clear();
        if (string == null) {
            return string;
        }
        Matcher matcher = ANNOTATION_PARSER.matcher(string);
        String remainder = string;
        while (matcher.find()) {
            PropertyAnnotation annotation = PropertiesFactory.eINSTANCE.createPropertyAnnotation();
            this.parseAnnotationValues(annotation, matcher.group(3));
            annotation.setName(matcher.group(1));
            this.getAnnotations().add((Object)annotation);
        }
        return remainder;
    }

    private void parseAnnotationValues(PropertyAnnotation annotation, String contents) {
        if (contents == null) {
            return;
        }
        Matcher matcher = ANNOTATION_VALUE_PARSER.matcher(contents);
        while (matcher.find()) {
            annotation.getValues().put(matcher.group(1), matcher.group(2));
        }
    }

    @Override
    public EList<PropertyAnnotation> getAnnotations() {
        return (EList)this.eDynamicGet(3, (EStructuralFeature)PropertiesPackage.Literals.PROPERTY__ANNOTATIONS, true, true);
    }

    @Override
    public String getCommentWithoutAnnotations() {
        String comment = this.getComment();
        if (comment == null) {
            return null;
        }
        return ANNOTATION_PARSER.matcher(comment).replaceAll("");
    }

    @Override
    public PropertyAnnotation findAnnotation(String name) {
        for (PropertyAnnotation annotation : this.getAnnotations()) {
            if (!name.equals(annotation.getName())) continue;
            return annotation;
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getKey();
            }
            case 1: {
                return this.getValue();
            }
            case 2: {
                return this.getComment();
            }
            case 3: {
                return this.getAnnotations();
            }
            case 4: {
                return this.getCommentWithoutAnnotations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setKey((String)newValue);
                return;
            }
            case 1: {
                this.setValue((String)newValue);
                return;
            }
            case 2: {
                this.setComment((String)newValue);
                return;
            }
            case 3: {
                this.getAnnotations().clear();
                this.getAnnotations().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setKey(KEY_EDEFAULT);
                return;
            }
            case 1: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 2: {
                this.setComment(COMMENT_EDEFAULT);
                return;
            }
            case 3: {
                this.getAnnotations().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return KEY_EDEFAULT == null ? this.getKey() != null : !KEY_EDEFAULT.equals(this.getKey());
            }
            case 1: {
                return VALUE_EDEFAULT == null ? this.getValue() != null : !VALUE_EDEFAULT.equals(this.getValue());
            }
            case 2: {
                return COMMENT_EDEFAULT == null ? this.getComment() != null : !COMMENT_EDEFAULT.equals(this.getComment());
            }
            case 3: {
                return !this.getAnnotations().isEmpty();
            }
            case 4: {
                return COMMENT_WITHOUT_ANNOTATIONS_EDEFAULT == null ? this.getCommentWithoutAnnotations() != null : !COMMENT_WITHOUT_ANNOTATIONS_EDEFAULT.equals(this.getCommentWithoutAnnotations());
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        return "Property [" + this.getKey() + " = " + this.getValue() + "] comment = " + this.getComment();
    }
}

