/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.types.PropertyConverter;
import org.jabylon.properties.types.PropertyScanner;
import org.jabylon.properties.util.PropertyResourceUtil;

public class PropertiesResourceImpl
extends ResourceImpl {
    private int savedProperties;
    public static final String OPTION_FILEMODE = "file.mode";
    public static final String OPTION_ENCODING = "encoding";

    public PropertiesResourceImpl(URI uri) {
        super(uri);
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        String type = this.getPropertyType(options);
        PropertyScanner scanner = PropertyResourceUtil.createScanner(type);
        PropertyConverter converter = scanner.createConverter(this.getURI());
        PropertyFile file = converter.load(inputStream, scanner.getEncoding());
        this.getContents().add((Object)file);
    }

    private String getPropertyType(Map<?, ?> options) {
        if (options != null && options.containsKey(OPTION_FILEMODE)) {
            return (String)options.get(OPTION_FILEMODE);
        }
        return "PROPERTIES_ENCODED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.savedProperties = 0;
        String type = this.getPropertyType(options);
        PropertyScanner scanner = PropertyResourceUtil.createScanner(type);
        String encoding = scanner.getEncoding();
        PropertyConverter converter = scanner.createConverter(this.getURI());
        try {
            PropertyFile file = (PropertyFile)this.getContents().get(0);
            this.savedProperties = converter.write(outputStream, file, encoding);
        }
        finally {
            outputStream.close();
        }
    }

    public int getSavedProperties() {
        return this.savedProperties;
    }
}

