/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.util;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.ResourceFolder;
import org.jabylon.properties.types.PropertyScanner;
import org.jabylon.properties.types.impl.JavaPropertyScanner;
import org.jabylon.properties.types.impl.JavaPropertyScannerUTF8;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyResourceUtil {
    private static ConcurrentMap<String, PropertyScanner> PROPERTY_SCANNERS;
    private static final Logger LOG;

    public static PropertyScanner createScanner(ProjectVersion version) {
        Project project = (Project)version.getParent();
        String propertyType = project.getPropertyType();
        return PropertyResourceUtil.createScanner(propertyType);
    }

    public static PropertyScanner createScanner(String propertyType) {
        PropertyScanner scanner = (PropertyScanner)PROPERTY_SCANNERS.get(propertyType);
        if (scanner == null) {
            throw new UnsupportedOperationException("unsupported property type: " + propertyType);
        }
        return scanner;
    }

    public static Map<String, PropertyScanner> getPropertyScanners() {
        TreeMap<String, PropertyScanner> sortedMap = new TreeMap<String, PropertyScanner>(PROPERTY_SCANNERS);
        return Collections.unmodifiableMap(sortedMap);
    }

    public static void createMissingDescriptorEntries(ProjectVersion parent, IProgressMonitor monitor) {
        EList children = parent.getChildren();
        monitor.beginTask("Adding missing localized resources", children.size() - 1);
        ProjectLocale template = parent.getTemplate();
        for (ProjectLocale locale : children) {
            if (locale == template) continue;
            if (locale != null && locale.getLocale() != null) {
                monitor.subTask("Add missing entries for " + locale.getLocale().getDisplayName());
            }
            PropertyResourceUtil.createMissingChildren(template, locale);
            monitor.worked(1);
        }
        monitor.subTask("");
        monitor.done();
    }

    public static void addNewTemplateDescriptor(PropertyFileDescriptor descriptor, ProjectVersion version) {
        if (!descriptor.eIsSet((EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__LOCATION)) {
            throw new IllegalArgumentException("Property File Descriptor location is not set");
        }
        Iterator i$ = version.getChildren().iterator();
        while (i$.hasNext()) {
            ProjectLocale locale;
            ProjectLocale parent = locale = (ProjectLocale)i$.next();
            String[] descriptorPart = descriptor.getLocation().segments();
            for (int i = 0; i < descriptorPart.length - 1; ++i) {
                Object child = parent.getChild(descriptorPart[i]);
                if (child == null) {
                    child = PropertiesFactory.eINSTANCE.createResourceFolder();
                    String childName = URI.decode((String)descriptorPart[i]);
                    child.setName(childName);
                    parent.getChildren().add(child);
                }
                parent = child;
            }
            if (!locale.isMaster()) {
                URI derivedLocation = PropertyResourceUtil.computeLocaleResourceLocation(locale.getLocale(), version, descriptor.getLocation());
                PropertyFileDescriptor translatedDescriptor = (PropertyFileDescriptor)parent.getChild(derivedLocation.lastSegment());
                if (translatedDescriptor == null) {
                    translatedDescriptor = PropertiesFactory.eINSTANCE.createPropertyFileDescriptor();
                    locale.getDescriptors().add((Object)translatedDescriptor);
                    parent.getChildren().add((Object)translatedDescriptor);
                }
                translatedDescriptor.setVariant(locale.getLocale());
                translatedDescriptor.setLocation(derivedLocation);
                translatedDescriptor.setName(derivedLocation.lastSegment());
                translatedDescriptor.setMaster(descriptor);
                if (new File(translatedDescriptor.absoluteFilePath().path()).isFile()) {
                    PropertyFile translatedFile = translatedDescriptor.loadProperties();
                    int size = translatedFile.getProperties().size();
                    translatedDescriptor.setKeys(size);
                    translatedDescriptor.updatePercentComplete();
                    continue;
                }
                parent.updatePercentComplete();
                continue;
            }
            if (parent.getChild(descriptor.getName()) != null) continue;
            parent.getChildren().add((Object)descriptor);
            descriptor.setName(descriptor.getLocation().lastSegment());
            version.getTemplate().getDescriptors().add((Object)descriptor);
            descriptor.updatePercentComplete();
        }
    }

    public static void addNewLocalizedDescriptor(PropertyFileDescriptor descriptor, ProjectLocale locale) {
        if (!descriptor.eIsSet((EStructuralFeature)PropertiesPackage.Literals.PROPERTY_FILE_DESCRIPTOR__LOCATION)) {
            throw new IllegalArgumentException("Property File Descriptor location is not set");
        }
        ProjectVersion version = (ProjectVersion)locale.getParent();
        ProjectLocale templateLocale = version.getTemplate();
        URI templateResourceLocation = PropertyResourceUtil.computeTemplateResourceLocation(locale.getLocale(), descriptor.getLocation(), templateLocale.getLocale(), version);
        Resolvable<?, ?> resolved = templateLocale.resolveChild(templateResourceLocation);
        PropertyFileDescriptor template = null;
        if (resolved instanceof PropertyFileDescriptor) {
            template = (PropertyFileDescriptor)resolved;
        }
        if (template == null) {
            throw new IllegalArgumentException("Template property " + templateResourceLocation + " doesn't exist");
        }
        Resolvable<?, ?> container = PropertyResourceUtil.getOrCreateFolder(locale, descriptor.getLocation().trimSegments(1).segments());
        if (container.getChild(descriptor.getLocation().lastSegment()) != null) {
            PropertyFileDescriptor child = (PropertyFileDescriptor)container.getChild(descriptor.getLocation().lastSegment());
            child.setMaster(null);
            container.getChildren().set(container.getChildren().indexOf((Object)child), (Object)descriptor);
            locale.getDescriptors().remove((Object)child);
        } else {
            container.getChildren().add((Object)descriptor);
        }
        descriptor.setMaster(template);
        locale.getDescriptors().add((Object)descriptor);
    }

    public static void addNewLocale(ProjectLocale locale, ProjectVersion version) {
        ProjectLocale template = version.getTemplate();
        version.getChildren().add((Object)locale);
        if (template == null) {
            template = PropertiesFactory.eINSTANCE.createProjectLocale();
            version.setTemplate(template);
            template.setName("template");
            version.getChildren().add((Object)template);
        }
        PropertyResourceUtil.createMissingChildren(template, locale);
    }

    private static void createMissingChildren(ProjectLocale template, ProjectLocale other) {
        EList<PropertyFileDescriptor> descriptors = template.getDescriptors();
        for (PropertyFileDescriptor descriptor : descriptors) {
            URI derivedLocation = PropertyResourceUtil.computeLocaleResourceLocation(other.getLocale(), (ProjectVersion)other.getParent(), descriptor.getLocation());
            Resolvable<?, ?> child = other.resolveChild(derivedLocation);
            if (child != null) continue;
            Resolvable<?, ?> folder = PropertyResourceUtil.getOrCreateFolder(other, derivedLocation.trimSegments(1).segments());
            PropertyFileDescriptor localeDescriptor = PropertiesFactory.eINSTANCE.createPropertyFileDescriptor();
            localeDescriptor.setMaster(descriptor);
            localeDescriptor.setVariant(other.getLocale());
            localeDescriptor.setLocation(derivedLocation);
            localeDescriptor.setProjectLocale(other);
            localeDescriptor.setParent(folder);
            localeDescriptor.setName(URI.decode((String)derivedLocation.lastSegment()));
        }
    }

    public static Resolvable<?, ?> getOrCreateFolder(Resolvable<?, ?> parent, String ... segments) {
        Resolvable<Object, Object> currentParent = parent;
        if (segments == null) {
            return parent;
        }
        for (String segment : segments) {
            Object child = currentParent.getChild(segment = URI.decode((String)segment));
            if (child == null) {
                child = PropertiesFactory.eINSTANCE.createResourceFolder();
                child.setName(segment);
                currentParent.getChildren().add(child);
            }
            currentParent = child;
        }
        return (ResourceFolder)currentParent;
    }

    public static URI computeTemplateResourceLocation(Locale locale, URI translationLocation, Locale masterLocale, ProjectVersion version) {
        PropertyScanner scanner = PropertyResourceUtil.createScanner(version);
        URI parentPath = version.absoluteFilePath();
        File path = scanner.findTemplate(new File(parentPath.path() + translationLocation.toString()), null);
        URI location = URI.createFileURI((String)path.getAbsolutePath());
        URI trimmedLocation = URI.createURI((String)location.segment(parentPath.segmentCount()));
        for (int i = parentPath.segmentCount() + 1; i < location.segmentCount(); ++i) {
            trimmedLocation = trimmedLocation.appendSegment(location.segment(i));
        }
        return trimmedLocation;
    }

    public static URI computeLocaleResourceLocation(Locale locale, ProjectVersion version, URI templateLocation) {
        PropertyScanner scanner = PropertyResourceUtil.createScanner(version);
        URI parentPath = version.absoluteFilePath();
        File path = scanner.computeTranslationPath(new File(URI.decode((String)parentPath.path()) + URI.decode((String)templateLocation.path())), version.getTemplate().getLocale(), locale);
        URI location = URI.createFileURI((String)path.getAbsolutePath());
        URI trimmedLocation = URI.createURI((String)location.segment(parentPath.segmentCount()));
        for (int i = parentPath.segmentCount() + 1; i < location.segmentCount(); ++i) {
            trimmedLocation = trimmedLocation.appendSegment(location.segment(i));
        }
        return trimmedLocation;
    }

    public static void removeDescriptor(PropertyFileDescriptor descriptor) {
        if (descriptor.isMaster()) {
            EList<PropertyFileDescriptor> derivedDescriptors = descriptor.getDerivedDescriptors();
            for (PropertyFileDescriptor derived : derivedDescriptors) {
                derived.setProjectLocale(null);
                Object parent = derived.getParent();
                if (parent != null) {
                    parent.updatePercentComplete();
                    if (parent.getChildren().size() == 1 && parent instanceof ResourceFolder) {
                        PropertyResourceUtil.deleteFolder((ResourceFolder)parent);
                    }
                }
                EcoreUtil.remove((EObject)derived);
            }
        } else {
            descriptor.setMaster(null);
        }
        Object parent = descriptor.getParent();
        if (parent != null && parent.getChildren().size() == 1 && parent instanceof ResourceFolder) {
            PropertyResourceUtil.deleteFolder((ResourceFolder)parent);
        }
        EcoreUtil.remove((EObject)descriptor);
        descriptor.getProjectLocale().getDescriptors().remove((Object)descriptor);
    }

    private static void deleteFolder(ResourceFolder folder) {
        ResourceFolder currentParent = folder;
        ResourceFolder lastParent = folder;
        while (currentParent instanceof ResourceFolder && currentParent.getChildren().size() <= 1) {
            lastParent = currentParent;
            currentParent = currentParent.getParent();
        }
        EcoreUtil.remove((EObject)lastParent);
    }

    static {
        LOG = LoggerFactory.getLogger(PropertyResourceUtil.class);
        PROPERTY_SCANNERS = new ConcurrentHashMap<String, PropertyScanner>();
        Bundle bundle = FrameworkUtil.getBundle(PropertyResourceUtil.class);
        if (bundle == null) {
            PROPERTY_SCANNERS.put("PROPERTIES_ENCODED", new JavaPropertyScanner());
            PROPERTY_SCANNERS.put("PROPERTIES_UTF8", new JavaPropertyScannerUTF8());
        } else {
            final BundleContext context = FrameworkUtil.getBundle(PropertyResourceUtil.class).getBundleContext();
            ServiceTracker tracker = new ServiceTracker(context, PropertyScanner.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<PropertyScanner, PropertyScanner>(){

                public PropertyScanner addingService(ServiceReference<PropertyScanner> reference) {
                    Object value = reference.getProperty("TYPE");
                    PropertyScanner service = (PropertyScanner)context.getService(reference);
                    if (value instanceof String) {
                        String type = (String)value;
                        PROPERTY_SCANNERS.put(type, service);
                        LOG.debug("Added property type {} {}", (Object)type, (Object)service);
                    } else {
                        LOG.error("PropertyScanner has no valid type {}", (Object)service);
                    }
                    return service;
                }

                public void removedService(ServiceReference<PropertyScanner> reference, PropertyScanner service) {
                    Object value = reference.getProperty("TYPE");
                    context.ungetService(reference);
                    if (value != null) {
                        PROPERTY_SCANNERS.remove(value);
                    }
                    LOG.debug("Removed property type {} {}", value);
                }

                public void modifiedService(ServiceReference<PropertyScanner> reference, PropertyScanner service) {
                }
            });
            tracker.open(true);
        }
    }
}

