/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.util.scanner;

import java.io.File;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.ResourceFolder;
import org.jabylon.properties.ScanConfiguration;
import org.jabylon.properties.types.PropertyScanner;
import org.jabylon.properties.util.scanner.PropertyFileAcceptor;

public abstract class AbstractScanFileAcceptor
implements PropertyFileAcceptor {
    private final ProjectVersion projectVersion;
    private PropertyScanner scanner;
    private ScanConfiguration config;
    private URI versionPath;

    public AbstractScanFileAcceptor(ProjectVersion projectVersion, PropertyScanner scanner, ScanConfiguration config) {
        this.projectVersion = projectVersion;
        this.scanner = scanner;
        this.config = config;
        this.versionPath = projectVersion.absolutPath();
    }

    protected URI calculateLocation(File file) {
        URI location = URI.createFileURI((String)file.getAbsolutePath());
        location = location.deresolve(this.versionPath);
        location = URI.createHierarchicalURI((String)location.scheme(), (String)location.authority(), (String)location.device(), (String[])location.segmentsList().subList(1, location.segmentCount()).toArray(new String[location.segmentCount() - 1]), (String)location.query(), (String)location.fragment());
        return location;
    }

    protected PropertyFileDescriptor createDescriptor(ProjectLocale projectLocale, URI childURI) {
        PropertyFileDescriptor fileDescriptor = PropertiesFactory.eINSTANCE.createPropertyFileDescriptor();
        fileDescriptor.setLocation(childURI);
        fileDescriptor.setName(childURI.lastSegment());
        fileDescriptor.setVariant(projectLocale.getLocale());
        projectLocale.getDescriptors().add((Object)fileDescriptor);
        Resolvable<?, Resolvable<?, ?>> parent = this.getOrCreateParent(projectLocale, childURI);
        parent.getChildren().add((Object)fileDescriptor);
        return fileDescriptor;
    }

    private Resolvable<?, Resolvable<?, ?>> getOrCreateParent(ProjectLocale projectLocale, URI childURI) {
        Resolvable<ProjectVersion, Resolvable<?, ?>> currentParent = projectLocale;
        String[] segments = childURI.segments();
        for (int i = 0; i < segments.length - 1; ++i) {
            currentParent = this.getOrCreate(currentParent, URI.decode((String)segments[i]));
        }
        return currentParent;
    }

    private Resolvable<?, Resolvable<?, ?>> getOrCreate(Resolvable<?, Resolvable<?, ?>> currentParent, String child) {
        ResourceFolder childObject = currentParent.getChild(child);
        if (childObject == null) {
            childObject = PropertiesFactory.eINSTANCE.createResourceFolder();
            childObject.setName(child);
            EList<Resolvable<?, ?>> children = currentParent.getChildren();
            children.add((Object)childObject);
        }
        return childObject;
    }

    public ProjectLocale getOrCreateProjectLocale(Locale locale) {
        ProjectLocale projectLocale = this.getProjectVersion().getProjectLocale(locale);
        if (projectLocale == null) {
            projectLocale = PropertiesFactory.eINSTANCE.createProjectLocale();
            projectLocale.setLocale(locale);
            this.getProjectVersion().getChildren().add((Object)projectLocale);
        }
        return projectLocale;
    }

    public ScanConfiguration getScanConfig() {
        return this.config;
    }

    public ProjectVersion getProjectVersion() {
        return this.projectVersion;
    }

    public PropertyScanner getPropertyScanner() {
        return this.scanner;
    }
}

