/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.api;

import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.view.CDOView;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.properties.Workspace;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.rest.api.ApiServlet;
import org.jabylon.security.auth.AuthenticationService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.OPTIONAL)
public class APIComponent {
    private static final String PROPERTY_SERVLET_ALIAS = "servlet.context";
    @Reference
    private HttpService httpService;
    @Reference
    private RepositoryConnector repositoryConnector;
    @Reference
    private PropertyPersistenceService persistenceService;
    @Reference
    private AuthenticationService authService;
    private CDOView view;
    private String webContext;
    private static final Logger logger = LoggerFactory.getLogger(APIComponent.class);

    public void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unbindHttpService(HttpService httpService) {
        logger.info("Http Service deactivated. Shutting down Jabylon REST API");
        this.httpService = null;
    }

    @Activate
    protected void startup(ComponentContext context) {
        try {
            this.webContext = this.getWebContext(context.getProperties());
            this.view = this.getRepositoryConnector().openView();
            CDOResource resource = this.view.getResource("workspace");
            logger.info("Starting up Jabylon REST API servlet at " + this.webContext);
            ApiServlet servlet = new ApiServlet((Workspace)resource.getContents().get(0), this.authService, this.persistenceService);
            this.httpService.registerServlet(this.webContext, (Servlet)servlet, null, null);
        }
        catch (ServletException e) {
            logger.error("Failed to register Jabylon REST API servlet", (Throwable)e);
        }
        catch (NamespaceException e) {
            logger.error("Failed to register Jabylon REST API servlet", (Throwable)e);
        }
    }

    @Deactivate
    protected void shutdown(ComponentContext context) {
        this.httpService.unregister(this.getWebContext(context.getProperties()));
        logger.info("Shutting down Jabylon REST API");
        this.view.close();
        this.getRepositoryConnector().close();
    }

    @Modified
    protected void modify(ComponentContext context) {
        String oldContext = this.webContext;
        this.webContext = this.getWebContext(context.getProperties());
        logger.info("Switching Jabylon REST API from {} to new context {}", (Object)oldContext, (Object)this.webContext);
        try {
            CDOResource resource = this.view.getResource("workspace");
            ApiServlet servlet = new ApiServlet((Workspace)resource.getContents().get(0), this.authService, this.persistenceService);
            this.httpService.registerServlet(this.webContext, (Servlet)servlet, null, null);
            this.httpService.unregister(this.getWebContext(context.getProperties()));
        }
        catch (ServletException e) {
            logger.error("Failed to register Jabylon REST API servlet", (Throwable)e);
        }
        catch (NamespaceException e) {
            logger.error("Failed to register Jabylon REST API servlet", (Throwable)e);
        }
    }

    public void bindRepositoryConnector(RepositoryConnector repositoryConnector) {
        this.repositoryConnector = repositoryConnector;
    }

    public void unbindRepositoryConnector(RepositoryConnector repositoryConnector) {
        this.repositoryConnector = null;
    }

    public RepositoryConnector getRepositoryConnector() {
        return this.repositoryConnector;
    }

    public PropertyPersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void bindPersistenceService(PropertyPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void unbindPersistenceService(PropertyPersistenceService persistenceService) {
        this.persistenceService = null;
    }

    public void bindAuthService(AuthenticationService service) {
        this.authService = service;
    }

    public void unbindAuthService(AuthenticationService service) {
        this.authService = null;
    }

    private String getWebContext(Dictionary<?, ?> properties) {
        Object result = properties.get(PROPERTY_SERVLET_ALIAS);
        if (result instanceof String) {
            String context = (String)result;
            return context;
        }
        return "/api";
    }
}

