/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.api;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.cdo.connector.Modification;
import org.jabylon.cdo.connector.TransactionUtil;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.DiffKind;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.Workspace;
import org.jabylon.properties.util.PropertyResourceUtil;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.rest.api.json.JSONEmitter;
import org.jabylon.security.CommonPermissions;
import org.jabylon.security.auth.AuthenticationService;
import org.jabylon.users.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiServlet
extends HttpServlet
implements Function<String, User> {
    private static final String BASIC_AUTH_REALM = "BASIC realm=\"Jabylon API\"";
    private static final String BASIC_PREFIX = "BASIC ";
    private static final long serialVersionUID = -1167994739560620821L;
    private Workspace workspace;
    private PropertyPersistenceService persistence;
    private AuthenticationService authService;
    private LoadingCache<String, User> cache;
    private static final Logger logger = LoggerFactory.getLogger(ApiServlet.class);

    public ApiServlet(Workspace workspace, AuthenticationService authService, PropertyPersistenceService persistence) {
        this.workspace = workspace;
        this.persistence = persistence;
        this.authService = authService;
    }

    public void init(ServletConfig config) throws ServletException {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(3).expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(10L).build(CacheLoader.from((Function)this));
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String type;
        logger.info("API request to {}", (Object)req.getPathInfo());
        Resolvable child = this.getObject(req.getPathInfo());
        if (child == null) {
            resp.sendError(404, "Resource " + req.getPathInfo() + " does not exist");
            return;
        }
        if (!this.isAuthorized(req, false, child)) {
            resp.setHeader("WWW-Authenticate", BASIC_AUTH_REALM);
            resp.sendError(401);
        }
        JSONEmitter emitter = new JSONEmitter();
        StringBuilder result = new StringBuilder();
        String depthString = req.getParameter("depth");
        int depth = 1;
        if (depthString != null) {
            depth = Integer.valueOf(depthString);
        }
        if ("file".equals(type = req.getParameter("type"))) {
            if (child instanceof PropertyFileDescriptor) {
                this.serveFile((PropertyFileDescriptor)child, resp);
            } else {
                this.serveArchive(child, resp);
            }
        } else {
            emitter.serialize((EObject)child, result, depth);
            resp.getOutputStream().print(result.toString());
        }
        resp.getOutputStream().close();
    }

    protected Resolvable getObject(String path) throws IOException {
        String info = path;
        if (info == null) {
            info = "";
        }
        if (info.startsWith("/workspace")) {
            info = info.replaceFirst("/workspace", "");
        }
        URI uri = URI.createURI((String)info);
        return this.workspace.resolveChild(uri);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URI uri = URI.createURI((String)req.getPathInfo());
        String[] segmentArray = uri.segments();
        if (segmentArray.length == 1) {
            this.putProject(req, uri, resp);
        } else if (segmentArray.length == 2) {
            this.putVersion(req, uri, resp);
        } else if (segmentArray.length == 3 && uri.hasTrailingPathSeparator()) {
            this.putLocale(req, uri, resp);
        } else {
            this.putPropertyFile(req, uri, resp);
        }
    }

    private void putPropertyFile(HttpServletRequest req, URI uri, HttpServletResponse resp) throws IOException {
        String[] segmentArray = uri.segments();
        String[] projectPart = new String[2];
        String[] descriptorPart = new String[segmentArray.length - projectPart.length];
        System.arraycopy(segmentArray, 0, projectPart, 0, projectPart.length);
        System.arraycopy(segmentArray, projectPart.length, descriptorPart, 0, descriptorPart.length);
        URI projectURI = URI.createHierarchicalURI((String[])projectPart, null, null);
        Resolvable version = this.getObject(projectURI.path());
        if (version instanceof ProjectVersion) {
            if (!this.isAuthorized(req, true, version)) {
                resp.setHeader("WWW-Authenticate", BASIC_AUTH_REALM);
                resp.sendError(401);
            }
            ProjectVersion projectVersion = (ProjectVersion)version;
            URI descriptorLocation = URI.createHierarchicalURI((String[])descriptorPart, null, null);
            File folder = new File(projectVersion.absoluteFilePath().toFileString());
            File propertyFile = new File(folder, descriptorLocation.path());
            final PropertyFileDiff diff = PropertiesFactory.eINSTANCE.createPropertyFileDiff();
            diff.setKind(propertyFile.isFile() ? DiffKind.MODIFY : DiffKind.ADD);
            this.updateFile(propertyFile, req.getInputStream());
            diff.setNewPath(descriptorLocation.path());
            diff.setOldPath(descriptorLocation.path());
            try {
                TransactionUtil.commit((EObject)projectVersion, (Modification)new Modification<ProjectVersion, ProjectVersion>(){

                    public ProjectVersion apply(ProjectVersion object) {
                        object.partialScan(PreferencesUtil.getScanConfigForProject((Project)((Project)object.getParent())), diff);
                        return object;
                    }
                });
                this.persistence.clearCache();
            }
            catch (CommitException e) {
                resp.sendError(500, "Commit failed: " + e.getMessage());
                logger.error("Commit failed", (Throwable)e);
            }
        } else {
            resp.sendError(404, "Resource " + projectURI.path() + " does not exist");
        }
    }

    private void putLocale(HttpServletRequest req, final URI uri, HttpServletResponse resp) throws IOException {
        URI truncated = uri.trimSegments(1);
        Resolvable object = this.getObject(truncated.path());
        if (object instanceof ProjectVersion) {
            ProjectVersion version = (ProjectVersion)object;
            if (!this.isAuthorized(req, true, (Resolvable<?, ?>)version)) {
                resp.setHeader("WWW-Authenticate", BASIC_AUTH_REALM);
                resp.sendError(401);
            }
            if (version.getChild(uri.lastSegment()) == null) {
                try {
                    TransactionUtil.commit((EObject)version, (Modification)new Modification<ProjectVersion, ProjectVersion>(){

                        public ProjectVersion apply(ProjectVersion object) {
                            ProjectLocale locale = PropertiesFactory.eINSTANCE.createProjectLocale();
                            locale.setName(uri.lastSegment());
                            locale.setLocale((Locale)PropertiesFactory.eINSTANCE.createFromString(PropertiesPackage.Literals.LOCALE, uri.lastSegment()));
                            PropertyResourceUtil.addNewLocale((ProjectLocale)locale, (ProjectVersion)object);
                            return object;
                        }
                    });
                }
                catch (CommitException e) {
                    logger.error("Commit failed", (Throwable)e);
                }
            }
        } else {
            resp.sendError(404, "Version " + truncated.path() + " does not exist");
        }
    }

    private void putVersion(HttpServletRequest req, final URI uri, HttpServletResponse resp) throws IOException {
        URI truncated = uri.trimSegments(1);
        Resolvable object = this.getObject(truncated.path());
        if (object instanceof Project) {
            Project project = (Project)object;
            if (!this.isAuthorized(req, true, (Resolvable<?, ?>)project)) {
                resp.setHeader("WWW-Authenticate", BASIC_AUTH_REALM);
                resp.sendError(401);
            }
            if (project.getChild(uri.lastSegment()) == null) {
                try {
                    TransactionUtil.commit((EObject)project, (Modification)new Modification<Project, Project>(){

                        public Project apply(Project object) {
                            ProjectVersion child = PropertiesFactory.eINSTANCE.createProjectVersion();
                            ProjectLocale locale = PropertiesFactory.eINSTANCE.createProjectLocale();
                            child.getChildren().add((Object)locale);
                            child.setTemplate(locale);
                            child.setName(uri.lastSegment());
                            object.getChildren().add((Object)child);
                            return object;
                        }
                    });
                }
                catch (CommitException e) {
                    logger.error("Commit failed", (Throwable)e);
                }
            }
        } else {
            resp.sendError(404, "Project " + truncated.path() + " does not exist");
        }
    }

    private void putProject(HttpServletRequest req, final URI uri, HttpServletResponse resp) throws IOException {
        if (!this.isAuthorized(req, true, (Resolvable<?, ?>)this.workspace)) {
            resp.setHeader("WWW-Authenticate", BASIC_AUTH_REALM);
            resp.sendError(401);
        }
        try {
            TransactionUtil.commit((EObject)this.workspace, (Modification)new Modification<Workspace, Workspace>(){

                public Workspace apply(Workspace object) {
                    Project child = PropertiesFactory.eINSTANCE.createProject();
                    child.setName(uri.lastSegment());
                    object.getChildren().add((Object)child);
                    return object;
                }
            });
        }
        catch (CommitException e) {
            logger.error("Commit failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(File destination, ServletInputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        destination.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(destination);
        try {
            int read;
            do {
                if ((read = inputStream.read(buffer)) <= 0) continue;
                out.write(buffer, 0, read);
            } while (read >= 0);
        }
        finally {
            out.close();
            inputStream.close();
        }
    }

    private void serveFile(PropertyFileDescriptor fileDescriptor, HttpServletResponse resp) throws IOException {
        URI path = fileDescriptor.absolutPath();
        File file = new File(path.path());
        ServletOutputStream outputStream = resp.getOutputStream();
        if (!file.exists()) {
            resp.setStatus(404);
            resp.sendError(404, "Resource " + fileDescriptor.fullPath() + " does not exist");
        } else {
            resp.setContentLength((int)file.length());
            resp.setContentType("application/octet-stream");
            this.writeFileToStream(file, (OutputStream)outputStream);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFileToStream(File file, OutputStream out) throws IOException {
        BufferedInputStream in = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void serveArchive(Resolvable<?, ?> parent, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/zip");
        resp.setHeader("Content-disposition", MessageFormat.format("attachment;filename={0}.zip", parent.getName()));
        ZipOutputStream out = new ZipOutputStream((OutputStream)resp.getOutputStream());
        this.addChildrenToArchive(out, parent);
        out.close();
        resp.flushBuffer();
    }

    private void addChildrenToArchive(ZipOutputStream out, Resolvable<?, ?> parent) throws IOException {
        EList children = parent.getChildren();
        for (Resolvable child : children) {
            if (child instanceof PropertyFileDescriptor) {
                PropertyFileDescriptor descriptor = (PropertyFileDescriptor)child;
                File file = new File(descriptor.absoluteFilePath().path());
                if (!file.exists()) continue;
                out.putNextEntry(new ZipEntry(((PropertyFileDescriptor)child).getLocation().path()));
                this.writeFileToStream(file, out);
                continue;
            }
            this.addChildrenToArchive(out, child);
        }
    }

    public String getServletInfo() {
        return null;
    }

    public void destroy() {
        this.cache = null;
    }

    protected boolean isAuthorized(HttpServletRequest request, boolean isEdit, Resolvable<?, ?> target) {
        User user = this.getUser(request);
        if (user == null) {
            return false;
        }
        return CommonPermissions.hasPermission((User)user, target, (String)(isEdit ? "edit" : "view"));
    }

    protected User getUser(HttpServletRequest request) {
        String auth = request.getHeader("Authorization");
        if (auth == null) {
            return this.authService.getAnonymousUser();
        }
        if (!auth.toUpperCase().startsWith(BASIC_PREFIX)) {
            return null;
        }
        String userpassEncoded = auth.substring(BASIC_PREFIX.length());
        try {
            return (User)this.cache.get((Object)userpassEncoded);
        }
        catch (ExecutionException e) {
        }
        catch (UncheckedExecutionException e) {
            // empty catch block
        }
        return null;
    }

    private User authenticate(String username, String password) {
        return this.authService.authenticateUser(username, password);
    }

    public User apply(String authHeader) {
        byte[] decoded = Base64.decode((byte[])authHeader.getBytes());
        String userpassDecoded = new String(decoded);
        String[] userPass = userpassDecoded.split(":");
        User result = null;
        if (userPass.length == 2) {
            String username = userPass[0].isEmpty() ? null : userPass[0];
            String password = userPass[1];
            result = this.authenticate(username, password);
        } else if (userPass.length == 1) {
            result = this.authenticate(null, userPass[0]);
        }
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Invalid Credentials");
    }
}

