/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.api.json;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;

public class JSONEmitter {
    public void serialize(EObject resolvable, StringBuilder result, int depth) {
        this.writeObject(resolvable, result, depth);
    }

    private void writeObject(EObject object, StringBuilder result, int depth) {
        if (depth == 0) {
            return;
        }
        result.append("{");
        this.writeAttributes(object, result, depth);
        result.append("}");
    }

    private void writeAttributes(EObject object, StringBuilder result, int depth) {
        PropertyFileDescriptor descriptor;
        PropertyFile properties;
        EList eAllAttributes = object.eClass().getEAllStructuralFeatures();
        boolean didWriteSeparator = false;
        for (EStructuralFeature eAttribute : eAllAttributes) {
            EReference ref;
            if (eAttribute.isTransient() || !object.eIsSet(eAttribute) || eAttribute instanceof EReference && (!(ref = (EReference)eAttribute).isContainment() || depth == 1)) continue;
            result.append("\"");
            result.append(eAttribute.getName());
            result.append("\"");
            result.append(":");
            if (eAttribute.isMany()) {
                this.writeMany(object, eAttribute, result, depth);
                didWriteSeparator = true;
                result.append(",");
                continue;
            }
            this.writeSingle(object, eAttribute, result, depth);
            didWriteSeparator = true;
            result.append(",");
        }
        if (object instanceof PropertyFileDescriptor && depth > 1 && !(properties = (descriptor = (PropertyFileDescriptor)object).loadProperties()).getProperties().isEmpty()) {
            didWriteSeparator = false;
            result.append("\"propertyFile\":");
            this.writeObject((EObject)properties, result, depth - 1);
        }
        if (didWriteSeparator) {
            result.setLength(result.length() - 1);
        }
    }

    private void writeSingle(EObject object, EStructuralFeature eAttribute, StringBuilder result, int depth) {
        this.writeSingleValue(object.eGet(eAttribute), eAttribute, result, depth);
    }

    private void writeSingleValue(Object value, EStructuralFeature attribute, StringBuilder result, int depth) {
        if (value instanceof String) {
            String string = (String)value;
            result.append("\"");
            result.append(string);
            result.append("\"");
        } else if (value instanceof Boolean) {
            result.append(value);
        } else if (value instanceof Number) {
            result.append(value);
        } else if (attribute instanceof EAttribute) {
            String newValue = attribute.getEContainingClass().getEPackage().getEFactoryInstance().convertToString(((EAttribute)attribute).getEAttributeType(), value);
            result.append("\"");
            result.append(newValue);
            result.append("\"");
        } else if (attribute instanceof EReference) {
            EReference ref = (EReference)attribute;
            if (!ref.isContainment()) {
                return;
            }
            this.writeObject((EObject)value, result, depth - 1);
        }
    }

    private void writeMany(EObject object, EStructuralFeature eAttribute, StringBuilder result, int depth) {
        Object value = object.eGet(eAttribute);
        if (value instanceof Collection) {
            result.append("[");
            Collection values = (Collection)value;
            for (Object singleValue : values) {
                this.writeSingleValue(singleValue, eAttribute, result, depth);
                result.append(",");
            }
            if (!values.isEmpty()) {
                result.setLength(result.length() - 1);
            }
            result.append("]");
        }
    }
}

