/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.StoreAccessorBase;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Store
extends Lifecycle
implements InternalStore {
    @Deprecated
    public static final long UNSPECIFIED_DATE = 0L;
    private String type;
    private Set<CDOID.ObjectType> objectIDTypes;
    private Set<IStore.ChangeFormat> supportedChangeFormats;
    private Set<IStore.RevisionTemporality> supportedRevisionTemporalities;
    private Set<IStore.RevisionParallelism> supportedRevisionParallelisms;
    private IStore.RevisionTemporality revisionTemporality = IStore.RevisionTemporality.NONE;
    private IStore.RevisionParallelism revisionParallelism = IStore.RevisionParallelism.NONE;
    private InternalRepository repository;
    private boolean dropAllDataOnActivate;
    @ReflectUtil.ExcludeFromDump
    private transient int lastBranchID;
    @ReflectUtil.ExcludeFromDump
    private transient int lastLocalBranchID;
    @ReflectUtil.ExcludeFromDump
    private transient long lastCommitTime;
    @ReflectUtil.ExcludeFromDump
    private transient Object lastCommitTimeLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private transient long lastNonLocalCommitTime;
    @ReflectUtil.ExcludeFromDump
    private transient Object lastNonLocalCommitTimeLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private transient ProgressDistributor indicatingCommitDistributor = new ProgressDistributor.Geometric(){

        public String toString() {
            String result = "indicatingCommitDistributor";
            if (Store.this.repository != null) {
                result = String.valueOf(result) + ": " + Store.this.repository.getName();
            }
            return result;
        }
    };

    public Store(String type, Set<CDOID.ObjectType> objectIDTypes, Set<IStore.ChangeFormat> supportedChangeFormats, Set<IStore.RevisionTemporality> supportedRevisionTemporalities, Set<IStore.RevisionParallelism> supportedRevisionParallelisms) {
        this.checkArg(!StringUtil.isEmpty((String)type), "Empty type");
        this.type = type;
        this.objectIDTypes = objectIDTypes;
        this.checkArg(supportedChangeFormats != null && !supportedChangeFormats.isEmpty(), "Empty supportedChangeFormats");
        this.supportedChangeFormats = supportedChangeFormats;
        this.checkArg(supportedRevisionTemporalities != null && !supportedRevisionTemporalities.isEmpty(), "Empty supportedRevisionTemporalities");
        this.supportedRevisionTemporalities = supportedRevisionTemporalities;
        this.checkArg(supportedRevisionParallelisms != null && !supportedRevisionParallelisms.isEmpty(), "Empty supportedRevisionParallelisms");
        this.supportedRevisionParallelisms = supportedRevisionParallelisms;
    }

    public Store(String type) {
        this.type = type;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return this.objectIDTypes;
    }

    protected void setObjectIDTypes(Set<CDOID.ObjectType> objectIDTypes) {
        this.objectIDTypes = objectIDTypes;
    }

    @Override
    public Set<IStore.ChangeFormat> getSupportedChangeFormats() {
        return this.supportedChangeFormats;
    }

    @Override
    public Set<IStore.RevisionTemporality> getSupportedRevisionTemporalities() {
        return this.supportedRevisionTemporalities;
    }

    @Override
    public final Set<IStore.RevisionParallelism> getSupportedRevisionParallelisms() {
        return this.supportedRevisionParallelisms;
    }

    @Override
    public IStore.RevisionTemporality getRevisionTemporality() {
        return this.revisionTemporality;
    }

    @Override
    public void setRevisionTemporality(IStore.RevisionTemporality revisionTemporality) {
        this.checkInactive();
        this.checkState(this.supportedRevisionTemporalities.contains((Object)revisionTemporality), "Revision temporality not supported: " + (Object)((Object)revisionTemporality));
        this.revisionTemporality = revisionTemporality;
    }

    @Override
    public IStore.RevisionParallelism getRevisionParallelism() {
        return this.revisionParallelism;
    }

    @Override
    public void setRevisionParallelism(IStore.RevisionParallelism revisionParallelism) {
        this.checkInactive();
        this.checkState(this.supportedRevisionParallelisms.contains((Object)revisionParallelism), "Revision parallelism not supported: " + (Object)((Object)revisionParallelism));
        this.revisionParallelism = revisionParallelism;
    }

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(IRepository repository) {
        this.repository = (InternalRepository)repository;
    }

    @Override
    public boolean isDropAllDataOnActivate() {
        return this.dropAllDataOnActivate;
    }

    @Override
    public void setDropAllDataOnActivate(boolean dropAllDataOnActivate) {
        this.dropAllDataOnActivate = dropAllDataOnActivate;
    }

    @Override
    public int getLastBranchID() {
        return this.lastBranchID;
    }

    @Override
    public void setLastBranchID(int lastBranchID) {
        this.lastBranchID = lastBranchID;
    }

    @Override
    public int getNextBranchID() {
        return ++this.lastBranchID;
    }

    @Override
    public int getLastLocalBranchID() {
        return this.lastLocalBranchID;
    }

    @Override
    public void setLastLocalBranchID(int lastLocalBranchID) {
        this.lastLocalBranchID = lastLocalBranchID;
    }

    @Override
    public int getNextLocalBranchID() {
        return --this.lastLocalBranchID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastCommitTime() {
        Object object = this.lastCommitTimeLock;
        synchronized (object) {
            return this.lastCommitTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastCommitTime(long lastCommitTime) {
        Object object = this.lastCommitTimeLock;
        synchronized (object) {
            if (this.lastCommitTime < lastCommitTime) {
                this.lastCommitTime = lastCommitTime;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastNonLocalCommitTime() {
        Object object = this.lastNonLocalCommitTimeLock;
        synchronized (object) {
            return this.lastNonLocalCommitTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastNonLocalCommitTime(long lastNonLocalCommitTime) {
        Object object = this.lastNonLocalCommitTimeLock;
        synchronized (object) {
            if (this.lastNonLocalCommitTime < lastNonLocalCommitTime) {
                this.lastNonLocalCommitTime = lastNonLocalCommitTime;
            }
        }
    }

    @Override
    public IStoreAccessor getReader(ISession session) {
        IStoreAccessor reader = null;
        StoreAccessorPool pool = this.getReaderPool(session, false);
        if (pool != null) {
            reader = pool.removeStoreAccessor(session);
        }
        if (reader == null && session != null) {
            CDOCommonView[] views;
            CDOCommonView[] cDOCommonViewArray = views = session.getViews();
            int n = views.length;
            int n2 = 0;
            while (n2 < n) {
                CDOCommonView view = cDOCommonViewArray[n2];
                pool = this.getWriterPool((IView)view, false);
                if (pool != null && (reader = pool.removeStoreAccessor(view)) != null) break;
                ++n2;
            }
        }
        if (reader == null) {
            reader = this.createReader(session);
            LifecycleUtil.activate((Object)reader);
        }
        return reader;
    }

    @Override
    public IStoreAccessor getWriter(ITransaction transaction) {
        IStoreAccessor writer = null;
        StoreAccessorPool pool = this.getWriterPool(transaction, false);
        if (pool != null) {
            writer = pool.removeStoreAccessor(transaction);
        }
        if (writer == null) {
            writer = this.createWriter(transaction);
            LifecycleUtil.activate((Object)writer);
        }
        return writer;
    }

    @Override
    public ProgressDistributor getIndicatingCommitDistributor() {
        return this.indicatingCommitDistributor;
    }

    public InternalCDORevision createRevision(EClass eClass, CDOID id) {
        CDORevisionFactory factory = this.repository.getRevisionManager().getFactory();
        InternalCDORevision revision = (InternalCDORevision)factory.createRevision(eClass);
        revision.setID(id);
        return revision;
    }

    protected void releaseAccessor(StoreAccessorBase accessor) {
        StoreAccessorPool pool = null;
        pool = accessor.isReader() ? this.getReaderPool(accessor.getSession(), true) : this.getWriterPool(accessor.getTransaction(), true);
        if (pool != null) {
            pool.addStoreAccessor(accessor);
        } else {
            accessor.deactivate();
        }
    }

    protected abstract StoreAccessorPool getReaderPool(ISession var1, boolean var2);

    protected abstract StoreAccessorPool getWriterPool(IView var1, boolean var2);

    protected abstract IStoreAccessor createReader(ISession var1);

    protected abstract IStoreAccessor createWriter(ITransaction var1);

    protected static <T> Set<T> set(T ... elements) {
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(elements)));
    }

    public static String idToString(CDOID id) {
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)id);
        return builder.toString();
    }

    public static CDOID stringToID(String string) {
        return CDOIDUtil.read((String)string);
    }

    public static IStoreAccessor.QueryResourcesContext.ExactMatch createExactMatchContext(final CDOID folderID, final String name, final CDOBranchPoint branchPoint) {
        return new IStoreAccessor.QueryResourcesContext.ExactMatch(){
            private CDOID resourceID;

            public CDOID getResourceID() {
                return this.resourceID;
            }

            public CDOBranch getBranch() {
                return branchPoint.getBranch();
            }

            public long getTimeStamp() {
                return branchPoint.getTimeStamp();
            }

            public CDOID getFolderID() {
                return folderID;
            }

            public String getName() {
                return name;
            }

            public boolean exactMatch() {
                return true;
            }

            public int getMaxResults() {
                return 1;
            }

            public boolean addResource(CDOID resourceID) {
                this.resourceID = resourceID;
                return false;
            }
        };
    }
}

