/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DiffKind implements Enumerator
{
    ADD(0, "ADD", "ADD"),
    REMOVE(1, "REMOVE", "REMOVE"),
    MODIFY(2, "MODIFY", "MODIFY"),
    COPY(3, "COPY", "COPY"),
    MOVE(4, "MOVE", "MOVE");

    public static final int ADD_VALUE = 0;
    public static final int REMOVE_VALUE = 1;
    public static final int MODIFY_VALUE = 2;
    public static final int COPY_VALUE = 3;
    public static final int MOVE_VALUE = 4;
    private static final DiffKind[] VALUES_ARRAY;
    public static final List<DiffKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DiffKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DiffKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DiffKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DiffKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DiffKind get(int value) {
        switch (value) {
            case 0: {
                return ADD;
            }
            case 1: {
                return REMOVE;
            }
            case 2: {
                return MODIFY;
            }
            case 3: {
                return COPY;
            }
            case 4: {
                return MOVE;
            }
        }
        return null;
    }

    private DiffKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DiffKind[]{ADD, REMOVE, MODIFY, COPY, MOVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

