/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReviewState implements Enumerator
{
    OPEN(0, "OPEN", "OPEN"),
    RESOLVED(1, "RESOLVED", "RESOLVED"),
    INVALID(2, "INVALID", "INVALID"),
    REOPENED(3, "REOPENED", "REOPENED");

    public static final int OPEN_VALUE = 0;
    public static final int RESOLVED_VALUE = 1;
    public static final int INVALID_VALUE = 2;
    public static final int REOPENED_VALUE = 3;
    private static final ReviewState[] VALUES_ARRAY;
    public static final List<ReviewState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ReviewState get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ReviewState result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ReviewState getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ReviewState result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ReviewState get(int value) {
        switch (value) {
            case 0: {
                return OPEN;
            }
            case 1: {
                return RESOLVED;
            }
            case 2: {
                return INVALID;
            }
            case 3: {
                return REOPENED;
            }
        }
        return null;
    }

    private ReviewState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ReviewState[]{OPEN, RESOLVED, INVALID, REOPENED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

