/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.impl;

import java.io.InputStream;
import java.util.Locale;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.jabylon.properties.Comment;
import org.jabylon.properties.DiffKind;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyAnnotation;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.properties.ResourceFolder;
import org.jabylon.properties.Review;
import org.jabylon.properties.ReviewState;
import org.jabylon.properties.ScanConfiguration;
import org.jabylon.properties.Severity;
import org.jabylon.properties.Workspace;
import org.jabylon.properties.impl.CommentImpl;
import org.jabylon.properties.impl.ProjectImpl;
import org.jabylon.properties.impl.ProjectLocaleImpl;
import org.jabylon.properties.impl.ProjectVersionImpl;
import org.jabylon.properties.impl.PropertyAnnotationImpl;
import org.jabylon.properties.impl.PropertyFileDescriptorImpl;
import org.jabylon.properties.impl.PropertyFileDiffImpl;
import org.jabylon.properties.impl.PropertyFileImpl;
import org.jabylon.properties.impl.PropertyImpl;
import org.jabylon.properties.impl.ResourceFolderImpl;
import org.jabylon.properties.impl.ReviewImpl;
import org.jabylon.properties.impl.ScanConfigurationImpl;
import org.jabylon.properties.impl.WorkspaceImpl;

public class PropertiesFactoryImpl
extends EFactoryImpl
implements PropertiesFactory {
    public static PropertiesFactory init() {
        try {
            PropertiesFactory thePropertiesFactory = (PropertiesFactory)EPackage.Registry.INSTANCE.getEFactory("http://uri.jabylon.org/properties");
            if (thePropertiesFactory != null) {
                return thePropertiesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new PropertiesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createPropertyFile();
            }
            case 1: {
                return this.createProperty();
            }
            case 2: {
                return this.createPropertyFileDescriptor();
            }
            case 3: {
                return this.createProject();
            }
            case 4: {
                return this.createProjectVersion();
            }
            case 5: {
                return this.createProjectLocale();
            }
            case 6: {
                return this.createWorkspace();
            }
            case 8: {
                return this.createScanConfiguration();
            }
            case 9: {
                return this.createReview();
            }
            case 10: {
                return this.createComment();
            }
            case 11: {
                return this.createPropertyFileDiff();
            }
            case 12: {
                return this.createResourceFolder();
            }
            case 13: {
                return this.createPropertyAnnotation();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.createSeverityFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createReviewStateFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createDiffKindFromString(eDataType, initialValue);
            }
            case 17: {
                return this.createLocaleFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createURIFromString(eDataType, initialValue);
            }
            case 19: {
                return this.createInputStreamFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.convertSeverityToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertReviewStateToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertDiffKindToString(eDataType, instanceValue);
            }
            case 17: {
                return this.convertLocaleToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertURIToString(eDataType, instanceValue);
            }
            case 19: {
                return this.convertInputStreamToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public PropertyFile createPropertyFile() {
        PropertyFileImpl propertyFile = new PropertyFileImpl();
        return propertyFile;
    }

    @Override
    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    @Override
    public PropertyFileDescriptor createPropertyFileDescriptor() {
        PropertyFileDescriptorImpl propertyFileDescriptor = new PropertyFileDescriptorImpl();
        return propertyFileDescriptor;
    }

    @Override
    public Project createProject() {
        ProjectImpl project = new ProjectImpl();
        return project;
    }

    @Override
    public ProjectVersion createProjectVersion() {
        ProjectVersionImpl projectVersion = new ProjectVersionImpl();
        return projectVersion;
    }

    @Override
    public ProjectLocale createProjectLocale() {
        ProjectLocaleImpl projectLocale = new ProjectLocaleImpl();
        return projectLocale;
    }

    @Override
    public Workspace createWorkspace() {
        WorkspaceImpl workspace = new WorkspaceImpl();
        return workspace;
    }

    @Override
    public ScanConfiguration createScanConfiguration() {
        ScanConfigurationImpl scanConfiguration = new ScanConfigurationImpl();
        return scanConfiguration;
    }

    @Override
    public Review createReview() {
        ReviewImpl review = new ReviewImpl();
        return review;
    }

    @Override
    public Comment createComment() {
        CommentImpl comment = new CommentImpl();
        return comment;
    }

    @Override
    public PropertyFileDiff createPropertyFileDiff() {
        PropertyFileDiffImpl propertyFileDiff = new PropertyFileDiffImpl();
        return propertyFileDiff;
    }

    @Override
    public ResourceFolder createResourceFolder() {
        ResourceFolderImpl resourceFolder = new ResourceFolderImpl();
        return resourceFolder;
    }

    @Override
    public PropertyAnnotation createPropertyAnnotation() {
        PropertyAnnotationImpl propertyAnnotation = new PropertyAnnotationImpl();
        return propertyAnnotation;
    }

    public Severity createSeverityFromString(EDataType eDataType, String initialValue) {
        Severity result = Severity.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSeverityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ReviewState createReviewStateFromString(EDataType eDataType, String initialValue) {
        ReviewState result = ReviewState.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertReviewStateToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DiffKind createDiffKindFromString(EDataType eDataType, String initialValue) {
        DiffKind result = DiffKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDiffKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Locale createLocaleFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        String[] strings = initialValue.split("_");
        String language = strings.length > 0 ? strings[0] : "";
        String country = strings.length > 1 ? strings[1] : "";
        String variant = strings.length > 2 ? strings[2] : "";
        return new Locale(language, country, variant);
    }

    public String convertLocaleToString(EDataType eDataType, Object instanceValue) {
        return instanceValue.toString();
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        return URI.createURI((String)initialValue, (boolean)true);
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        return instanceValue.toString();
    }

    public InputStream createInputStreamFromString(EDataType eDataType, String initialValue) {
        return (InputStream)super.createFromString(eDataType, initialValue);
    }

    public String convertInputStreamToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public PropertiesPackage getPropertiesPackage() {
        return (PropertiesPackage)this.getEPackage();
    }

    @Deprecated
    public static PropertiesPackage getPackage() {
        return PropertiesPackage.eINSTANCE;
    }
}

