/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.impl;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResolvableImpl<P extends Resolvable<?, ?>, C extends Resolvable<?, ?>>
extends CDOObjectImpl
implements Resolvable<P, C> {
    protected static final int PERCENT_COMPLETE_EDEFAULT = 0;
    protected static final String NAME_EDEFAULT = null;
    private static final Logger logger = LoggerFactory.getLogger(ResolvableImpl.class);

    protected ResolvableImpl() {
    }

    protected EClass eStaticClass() {
        return PropertiesPackage.Literals.RESOLVABLE;
    }

    protected int eStaticFeatureCount() {
        return 0;
    }

    @Override
    public int getPercentComplete() {
        return (Integer)this.eDynamicGet(0, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__PERCENT_COMPLETE, true, true);
    }

    @Override
    public void setPercentComplete(int newPercentComplete) {
        this.eDynamicSet(0, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__PERCENT_COMPLETE, newPercentComplete);
    }

    @Override
    public EList<C> getChildren() {
        return (EList)this.eDynamicGet(1, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__CHILDREN, true, true);
    }

    @Override
    public P getParent() {
        return (P)((Resolvable)this.eDynamicGet(2, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__PARENT, true, true));
    }

    public NotificationChain basicSetParent(P newParent, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newParent, 2, msgs);
        return msgs;
    }

    @Override
    public void setParent(P newParent) {
        this.eDynamicSet(2, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__PARENT, newParent);
    }

    @Override
    public String getName() {
        return (String)this.eDynamicGet(3, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__NAME, true, true);
    }

    @Override
    public void setName(String newName) {
        this.eDynamicSet(3, (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__NAME, newName);
    }

    @Override
    public URI fullPath() {
        EObject parent = this.eContainer();
        while (parent != null) {
            if (!(parent instanceof Resolvable)) continue;
            Resolvable resolvable = (Resolvable)parent;
            URI path = this.relativePath();
            if (path != null) {
                URI fullParentPath = resolvable.fullPath();
                if (fullParentPath != null) {
                    return fullParentPath.appendSegments(path.segments());
                }
                return this.relativePath();
            }
            return resolvable.fullPath();
        }
        return this.relativePath();
    }

    @Override
    public URI relativePath() {
        if (this.getName() == null) {
            return null;
        }
        return URI.createURI((String)this.getName(), (boolean)false);
    }

    @Override
    public URI absolutPath() {
        ResolvableImpl object;
        for (object = this; object != null && !(object instanceof Workspace); object = object.eContainer()) {
        }
        if (object instanceof Workspace) {
            Workspace workspace = (Workspace)((Object)object);
            URI root = workspace.getRoot();
            if (root == null) {
                return null;
            }
            if (root.isRelative()) {
                File f = new File("");
                URI workingDir = URI.createFileURI((String)f.getAbsolutePath());
                root = workingDir.appendSegments(root.segments());
            }
            return root.appendSegments(this.fullPath().segments());
        }
        return null;
    }

    @Override
    public int updatePercentComplete() {
        P parent = this.getParent();
        int percentComplete = this.internalUpdatePercentComplete();
        if (percentComplete != this.getPercentComplete()) {
            this.setPercentComplete(percentComplete);
        }
        if (parent != null) {
            parent.updatePercentComplete();
        }
        return percentComplete;
    }

    @Override
    public Resolvable<?, ?> resolveChild(URI path) {
        return this.resolveChild(path.segmentsList());
    }

    @Override
    public Resolvable<?, ?> resolveChild(List<String> pathSegments) {
        if (pathSegments.isEmpty()) {
            return this;
        }
        for (Resolvable child : this.getChildren()) {
            String name = child.getName();
            if (name == null) {
                logger.error("found child with 'null' name during resolve at " + this.fullPath());
                continue;
            }
            if (!name.equals(URI.decode((String)pathSegments.get(0)))) continue;
            return child.resolveChild(pathSegments.subList(1, pathSegments.size()));
        }
        return null;
    }

    @Override
    public URI absoluteFilePath() {
        return this.absolutPath();
    }

    @Override
    public URI toURI() {
        ArrayDeque<String> segments = new ArrayDeque<String>();
        for (ResolvableImpl object = this; object != null; object = object.eContainer()) {
            Resolvable r;
            if (!(object instanceof Resolvable) || (r = (Resolvable)object).getName() == null) continue;
            segments.push(r.getName());
        }
        return URI.createHierarchicalURI((String[])segments.toArray(new String[segments.size()]), null, null);
    }

    @Override
    public C getChild(String name) {
        for (Resolvable child : this.getChildren()) {
            String childName = child.getName();
            if (childName == null) {
                logger.error("found child with 'null' name during resolve at " + this.fullPath());
                continue;
            }
            if (!childName.equals(name)) continue;
            return (C)child;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getChildren()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParent((Resolvable)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getChildren()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return this.basicSetParent(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 2: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, Resolvable.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public int internalUpdatePercentComplete() {
        if (this.getChildren().isEmpty()) {
            return 100;
        }
        int complete = 0;
        for (Resolvable child : this.getChildren()) {
            complete += child.getPercentComplete();
        }
        return (int)Math.floor(complete / this.getChildren().size());
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPercentComplete();
            }
            case 1: {
                return this.getChildren();
            }
            case 2: {
                return this.getParent();
            }
            case 3: {
                return this.getName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPercentComplete((Integer)newValue);
                return;
            }
            case 1: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setParent((Resolvable)newValue);
                return;
            }
            case 3: {
                this.setName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPercentComplete(0);
                return;
            }
            case 1: {
                this.getChildren().clear();
                return;
            }
            case 2: {
                this.setParent(null);
                return;
            }
            case 3: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getPercentComplete() != 0;
            }
            case 1: {
                return !this.getChildren().isEmpty();
            }
            case 2: {
                return this.getParent() != null;
            }
            case 3: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (Exception e) {
            logger.error("Exception during toString", (Throwable)e);
            return super.toString();
        }
    }
}

