/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.types.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.types.PropertyConverter;
import org.jabylon.properties.util.PropertiesResourceImpl;

public class POHelper
implements PropertyConverter {
    private static final Pattern ID_PATTERN = Pattern.compile("msgid \"(.*)\"");
    private static final Pattern VALUE_PATTERN = Pattern.compile("msgstr \"(.*)\"");

    public Property readProperty(BufferedReader reader) throws IOException {
        String line = null;
        Property property = null;
        StringBuilder comment = new StringBuilder();
        StringBuilder propertyValue = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            Matcher matcher;
            if ((line = line.trim()).startsWith("\"") || line.length() == 0) continue;
            if (this.isComment(line)) {
                if (comment.length() > 0) {
                    comment.append("\n");
                }
                if (line.length() <= 1) continue;
                comment.append(line.substring(1).trim());
                continue;
            }
            if (property == null) {
                matcher = ID_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                property = PropertiesFactory.eINSTANCE.createProperty();
                property.setKey(matcher.group(1).replace("\\n", "\n"));
                if (comment.length() <= 0) continue;
                property.setComment(comment.toString());
                continue;
            }
            matcher = VALUE_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            property.setValue(matcher.group(1).replace("\\n", "\n"));
            return property;
        }
        return property;
    }

    private boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("!");
    }

    public static void main(String[] args) throws IOException {
        boolean template = false;
        URL url = new URL("http://pootle.locamotion.org/export/terminology/de/essential.po");
        InputStream openStream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(openStream, "UTF-8"));
        Property property = null;
        POHelper helper = new POHelper();
        PropertyFile file = PropertiesFactory.eINSTANCE.createPropertyFile();
        while ((property = helper.readProperty(reader)) != null) {
            if (template) {
                property.setValue(property.getKey());
            }
            file.getProperties().add((Object)property);
        }
        PropertiesResourceImpl resource = new PropertiesResourceImpl(URI.createFileURI((String)"messages.properties"));
        resource.getContents().add((Object)file);
        resource.save(new HashMap());
    }

    @Override
    public PropertyFile load(InputStream in, String encoding) throws IOException {
        return null;
    }

    @Override
    public int write(OutputStream out, PropertyFile file, String encoding) throws IOException {
        return 0;
    }
}

