/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.types.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyAnnotation;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.types.PropertyConverter;
import org.jabylon.properties.util.NativeToAsciiConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesHelper
implements PropertyConverter {
    private boolean unicodeEscaping;
    private static final int MAX_BOM_LENGTH = 4;
    private String licenseHeader;
    private boolean checkedForHeader;
    private URI uri;
    private long lineNo = 0L;
    final Logger logger = LoggerFactory.getLogger(PropertiesHelper.class);

    public PropertiesHelper() {
        this(true);
        this.checkedForHeader = false;
    }

    public PropertiesHelper(boolean unicodeEscaping) {
        this(unicodeEscaping, null);
    }

    public PropertiesHelper(boolean unicodeEscaping, URI uri) {
        this.unicodeEscaping = unicodeEscaping;
        if (uri == null) {
            uri = URI.createURI((String)"NONE SUPPLIED");
        }
        this.uri = uri;
    }

    public Property readProperty(BufferedReader reader) throws IOException {
        String line = null;
        Property property = null;
        StringBuilder comment = new StringBuilder();
        StringBuilder propertyValue = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            ++this.lineNo;
            if ((line = line.trim()).length() == 0) {
                if (this.checkedForHeader) continue;
                this.licenseHeader = comment.toString();
                comment.setLength(0);
                this.checkedForHeader = true;
            }
            if (this.isComment(line)) {
                if (comment.length() > 0) {
                    comment.append("\n");
                }
                if (line.length() <= 1) continue;
                comment.append(this.parseComment(line));
                continue;
            }
            propertyValue.append(NativeToAsciiConverter.convertEncodedToUnicode(line));
            if (line.endsWith("\\")) continue;
            property = PropertiesFactory.eINSTANCE.createProperty();
            if (comment.length() > 0) {
                property.setComment(comment.toString());
                PropertyAnnotation nonTranslatable = property.findAnnotation("non-translatable");
                if (nonTranslatable != null) {
                    this.logger.info("Property {} in file {} is marked as non-translatable. Skipping", (Object)property.getKey(), (Object)this.uri);
                    propertyValue.setLength(0);
                    comment.setLength(0);
                    continue;
                }
            }
            if (propertyValue.length() == 0) continue;
            String[] parts = this.split(propertyValue.toString());
            if (parts == null || parts[0] == null) {
                this.logger.error("Invalid line {}: \"{}\" in property file \"{}\". Skipping", new Object[]{this.lineNo, propertyValue, this.uri});
                propertyValue.setLength(0);
                continue;
            }
            property.setKey(parts[0]);
            property.setValue(parts[1]);
            this.checkedForHeader = true;
            return property;
        }
        if (property != null && property.getKey() == null) {
            return null;
        }
        return property;
    }

    protected String parseComment(String line) {
        return line.substring(1).trim();
    }

    protected String[] split(String propertyValue) {
        boolean escape = false;
        StringBuilder buffer = new StringBuilder(propertyValue.length());
        String[] result = new String[2];
        for (char c : propertyValue.toCharArray()) {
            if (!escape) {
                if (result[0] == null && (c == ':' || c == '=')) {
                    String string = buffer.toString().trim();
                    if (string.length() <= 0) {
                        return null;
                    }
                    result[0] = string;
                    buffer.setLength(0);
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
            }
            escape = false;
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string.startsWith(" ")) {
            string = string.substring(1);
        }
        if (string.length() > 0) {
            result[1] = string;
        }
        return result;
    }

    protected boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("!");
    }

    public void writeProperty(Writer writer, Property property) throws IOException {
        this.writeCommentAndAnnotations(writer, property);
        String key = property.getKey();
        key = key.replaceAll("([ :=\n])", "\\\\$1");
        if (this.unicodeEscaping) {
            writer.write(NativeToAsciiConverter.convertUnicodeToEncoded(key, true));
        } else {
            writer.write(key);
        }
        writer.write(" = ");
        String value = property.getValue();
        if (value != null) {
            if (value.startsWith(" ")) {
                value = "\\" + value;
            }
            value = value.replace("\r", "\\r");
            value = value.replace("\n", "\\n");
            if (this.unicodeEscaping) {
                value = NativeToAsciiConverter.convertUnicodeToEncoded(value, true);
            }
            writer.write(value);
        }
        writer.write(10);
    }

    protected void writeCommentAndAnnotations(Writer writer, Property property) throws IOException {
        if (property.eIsSet((EStructuralFeature)PropertiesPackage.Literals.PROPERTY__COMMENT) || property.getAnnotations().size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (PropertyAnnotation annotation : property.getAnnotations()) {
                builder.append(annotation);
            }
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(property.getCommentWithoutAnnotations());
            this.writeComment(writer, builder.toString());
        }
    }

    protected void writeComment(Writer writer, String comment) throws IOException {
        comment = comment.replace("\n", "\n#");
        writer.write("#");
        writer.write(comment);
        writer.write(10);
    }

    public static ContentHandler.ByteOrderMark checkForBom(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark/rest: " + inputStream);
        }
        inputStream.mark(4);
        ContentHandler.ByteOrderMark bom = ContentHandler.ByteOrderMark.read((InputStream)inputStream);
        if (bom == null) {
            inputStream.reset();
        }
        return bom;
    }

    public String getLicenseHeader() {
        return this.licenseHeader;
    }

    public void writeLicenseHeader(Writer writer, String licenseHeader) throws IOException {
        if (licenseHeader == null || licenseHeader.isEmpty()) {
            return;
        }
        this.writeComment(writer, licenseHeader);
        writer.write(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(OutputStream out, PropertyFile file, String encoding) throws IOException {
        int savedProperties = 0;
        if ("UTF-8".equals(encoding)) {
            out.write(ContentHandler.ByteOrderMark.UTF_8.bytes());
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoding));){
            this.writeLicenseHeader(writer, file.getLicenseHeader());
            for (Property property : file.getProperties()) {
                if (!this.isFilled(property)) continue;
                this.writeProperty(writer, property);
                ++savedProperties;
            }
        }
        return savedProperties;
    }

    protected boolean isFilled(Property property) {
        if (property == null) {
            return false;
        }
        if (property.getKey() == null || property.getKey().length() == 0) {
            return false;
        }
        return property.getValue() != null && property.getValue().length() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyFile load(InputStream in, String encoding) throws IOException {
        ContentHandler.ByteOrderMark bom;
        String derivedEncoding;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        if ((derivedEncoding = this.deriveEncoding(bom = PropertiesHelper.checkForBom(in))) != null) {
            if (encoding.equals("UTF-16") && derivedEncoding.startsWith("UTF-16")) {
                encoding = derivedEncoding;
            } else if (!encoding.equals(derivedEncoding)) {
                this.logger.warn("Encoding was specified as {} but according to the BOM it is {}. Using the value from the BOM instead", (Object)encoding, (Object)derivedEncoding);
                encoding = derivedEncoding;
            }
        }
        PropertyFile file = PropertiesFactory.eINSTANCE.createPropertyFile();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding));){
            Property p = null;
            while ((p = this.readProperty(reader)) != null) {
                file.getProperties().add((Object)p);
            }
        }
        file.setLicenseHeader(this.getLicenseHeader());
        return file;
    }

    protected String deriveEncoding(ContentHandler.ByteOrderMark bom) {
        if (bom == null) {
            return null;
        }
        switch (bom) {
            case UTF_16BE: {
                return "UTF-16BE";
            }
            case UTF_16LE: {
                return "UTF-16LE";
            }
            case UTF_8: {
                return "UTF-8";
            }
        }
        return null;
    }

    public boolean isUnicodeEscaping() {
        return this.unicodeEscaping;
    }
}

