/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.types.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyAnnotation;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.types.PropertyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TMXConverter
implements PropertyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(TMXConverter.class);

    @Override
    public PropertyFile load(InputStream in, String encoding) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            PropertyFile file = PropertiesFactory.eINSTANCE.createPropertyFile();
            TMXHandler handler = new TMXHandler(file);
            parser.getXMLReader().setEntityResolver(handler);
            parser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parser.parse(in, (DefaultHandler)handler);
            return file;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int write(OutputStream out, PropertyFile file, String encoding) throws IOException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    static class TMXHandler
    extends DefaultHandler {
        private PropertyFile file;
        private String srcLanguage;
        private Property current;
        private String currentLanguage;
        private String targetLanguage;
        private StringBuilder currentValue;

        public TMXHandler(PropertyFile file) {
            this.file = file;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.is("header", uri, qName, localName)) {
                this.srcLanguage = attributes.getValue("", "srclang");
            } else if (this.is("tu", uri, qName, localName)) {
                this.current = PropertiesFactory.eINSTANCE.createProperty();
            } else if (this.is("tuv", uri, qName, localName)) {
                this.currentLanguage = attributes.getValue("xml:lang");
            } else if (this.is("seg", uri, qName, localName)) {
                this.currentValue = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentValue != null) {
                this.currentValue.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.is("tu", uri, qName, localName)) {
                if (this.current != null) {
                    if (this.current.getValue() == null || this.current.getKey() == null) {
                        LOG.error("Invalid property in TMX file: " + this.current);
                    } else {
                        PropertyAnnotation annotation = PropertiesFactory.eINSTANCE.createPropertyAnnotation();
                        annotation.setName("language");
                        annotation.getValues().put("source", this.normalizeLanguage(this.srcLanguage));
                        annotation.getValues().put("target", this.normalizeLanguage(this.targetLanguage));
                        this.current.getAnnotations().add((Object)annotation);
                        this.file.getProperties().add((Object)this.current);
                    }
                }
                this.current = null;
            } else if (this.is("seg", uri, qName, localName) && this.currentValue != null && this.current != null) {
                if (this.currentLanguage != null && this.currentLanguage.equals(this.srcLanguage)) {
                    this.current.setKey(this.currentValue.toString());
                } else {
                    this.targetLanguage = this.currentLanguage;
                    this.current.setValue(this.currentValue.toString());
                }
                this.currentValue = null;
            }
        }

        private String normalizeLanguage(String xmlLang) {
            if (xmlLang == null || xmlLang.isEmpty()) {
                return "en";
            }
            return Locale.forLanguageTag(xmlLang).toString();
        }

        protected boolean is(String expextedElementName, String uri, String qname, String localname) {
            return expextedElementName.equals(localname) || expextedElementName.equals(qname);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return null;
        }
    }
}

