/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.util;

public class NativeToAsciiConverter {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String convertEncodedToUnicode(String str) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = str.charAt(x++)) == 92 && x + 1 <= len) {
                if ((aChar = str.charAt(x++)) == 117 && x + 4 <= len) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = str.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                value = aChar;
                                System.err.println("PropertiesDeserializer: bad character encoding for string:" + str);
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                } else if (aChar == 117) {
                    outBuffer.append("\\");
                } else {
                    outBuffer.append("\\");
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static String convertUnicodeToEncoded(String str, boolean lowerCase) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        for (int x = 0; x < len; ++x) {
            char aChar = str.charAt(x);
            if (aChar == '\n' || aChar == '\r') {
                outBuffer.append(aChar);
                continue;
            }
            if (aChar < ' ' || aChar > '~') {
                outBuffer.append('\\');
                outBuffer.append('u');
                outBuffer.append(NativeToAsciiConverter.toHex(aChar >> 12 & 0xF, lowerCase));
                outBuffer.append(NativeToAsciiConverter.toHex(aChar >> 8 & 0xF, lowerCase));
                outBuffer.append(NativeToAsciiConverter.toHex(aChar >> 4 & 0xF, lowerCase));
                outBuffer.append(NativeToAsciiConverter.toHex(aChar & 0xF, lowerCase));
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble, boolean lowerCase) {
        char hexChar = HEX_DIGITS[nibble & 0xF];
        if (lowerCase) {
            return Character.toLowerCase(hexChar);
        }
        return hexChar;
    }
}

