/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.types.PropertyConverter;
import org.jabylon.properties.types.PropertyScanner;
import org.jabylon.properties.util.PropertyResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesResourceImpl
extends ResourceImpl {
    private int savedProperties;
    public static final String OPTION_FILEMODE = "file.mode";
    public static final String OPTION_ENCODING = "encoding";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesResourceImpl.class);
    private static final LoadingCache<String, ReentrantReadWriteLock> LOCKS = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, ReentrantReadWriteLock>(){

        public ReentrantReadWriteLock load(String key) throws Exception {
            return new ReentrantReadWriteLock();
        }
    });

    public PropertiesResourceImpl(URI uri) {
        super(uri);
    }

    public void load(Map<?, ?> options) throws IOException {
        ReentrantReadWriteLock lock = (ReentrantReadWriteLock)LOCKS.getUnchecked((Object)(this.getURI() == null ? "temp" : this.getURI().toFileString()));
        ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
        try {
            if (!readLock.tryLock(2L, TimeUnit.MINUTES)) {
                LOG.warn("Failed to aquire read lock for {}", (Object)this.getURI());
                readLock = null;
                throw new IOException("Could not load " + this.getURI());
            }
            super.load(options);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while trying to aquire read lock for {}", (Object)this.getURI());
            throw new IOException("Could not load " + this.getURI());
        }
        finally {
            if (readLock != null) {
                readLock.unlock();
            }
        }
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        String type = this.getPropertyType(options);
        PropertyScanner scanner = PropertyResourceUtil.createScanner(type);
        PropertyConverter converter = scanner.createConverter(this.getURI());
        PropertyFile file = converter.load(inputStream, scanner.getEncoding());
        this.getContents().add((Object)file);
    }

    private String getPropertyType(Map<?, ?> options) {
        if (options != null && options.containsKey(OPTION_FILEMODE)) {
            return (String)options.get(OPTION_FILEMODE);
        }
        return "PROPERTIES_ENCODED";
    }

    public void save(Map<?, ?> options) throws IOException {
        block7: {
            ReentrantReadWriteLock lock = (ReentrantReadWriteLock)LOCKS.getUnchecked((Object)(this.getURI() == null ? "temp" : this.getURI().toFileString()));
            ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
            try {
                if (writeLock.tryLock(2L, TimeUnit.MINUTES)) {
                    super.save(options);
                    break block7;
                }
                writeLock = null;
                throw new IOException("Could not save " + this.getURI() + ". It was locked");
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while trying to aquire write lock for {}", (Object)this.getURI());
                throw new IOException("Could not save " + this.getURI());
            }
            finally {
                if (writeLock != null) {
                    writeLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.savedProperties = 0;
        String type = this.getPropertyType(options);
        PropertyScanner scanner = PropertyResourceUtil.createScanner(type);
        String encoding = scanner.getEncoding();
        PropertyConverter converter = scanner.createConverter(this.getURI());
        try {
            PropertyFile file = (PropertyFile)this.getContents().get(0);
            this.savedProperties = converter.write(outputStream, file, encoding);
        }
        finally {
            outputStream.close();
        }
    }

    public int getSavedProperties() {
        return this.savedProperties;
    }
}

