/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.util.scanner;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.ScanConfiguration;
import org.jabylon.properties.types.PropertyScanner;
import org.jabylon.properties.util.scanner.AbstractScanFileAcceptor;

public class FullScanFileAcceptor
extends AbstractScanFileAcceptor {
    public FullScanFileAcceptor(ProjectVersion projectVersion, PropertyScanner scanner, ScanConfiguration config) {
        super(projectVersion, scanner, config);
    }

    @Override
    public void newMatch(File file) {
        URI location = this.calculateLocation(file);
        if (this.getProjectVersion().getTemplate() == null) {
            this.getProjectVersion().setTemplate(PropertiesFactory.eINSTANCE.createProjectLocale());
            this.getProjectVersion().getTemplate().setName("template");
            this.getProjectVersion().getChildren().add((Object)this.getProjectVersion().getTemplate());
        }
        PropertyFileDescriptor descriptor = this.createDescriptor(this.getProjectVersion().getTemplate(), location);
        this.getProjectVersion().getTemplate().getDescriptors().add((Object)descriptor);
        PropertyFile propertyFile = descriptor.loadProperties();
        descriptor.setKeys(propertyFile.getProperties().size());
        descriptor.updatePercentComplete();
        Locale locale = this.getPropertyScanner().getLocale(file);
        if (locale != null) {
            descriptor.setVariant(locale);
        }
        Map<Locale, File> translations = this.getPropertyScanner().findTranslations(file, this.getScanConfig());
        Set<Map.Entry<Locale, File>> set = translations.entrySet();
        for (Map.Entry<Locale, File> entry : set) {
            ProjectLocale projectLocale = this.getOrCreateProjectLocale(entry.getKey());
            URI childURI = this.calculateLocation(entry.getValue());
            PropertyFileDescriptor fileDescriptor = this.createDescriptor(projectLocale, childURI);
            fileDescriptor.setMaster(descriptor);
            PropertyFile translatedFile = fileDescriptor.loadProperties();
            int size = translatedFile.getProperties().size();
            fileDescriptor.setKeys(size);
        }
    }
}

