/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.util.scanner;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.ScanConfiguration;
import org.jabylon.properties.types.PropertyScanner;
import org.jabylon.properties.util.PropertyResourceUtil;
import org.jabylon.properties.util.scanner.AbstractScanFileAcceptor;

public class PartialScanFileAcceptor
extends AbstractScanFileAcceptor {
    public PartialScanFileAcceptor(ProjectVersion projectVersion, PropertyScanner scanner, ScanConfiguration config) {
        super(projectVersion, scanner, config);
    }

    @Override
    public void newMatch(File file) {
        if (this.getPropertyScanner().isTemplate(file, this.getScanConfig().getMasterLocale())) {
            this.newTemplateMatch(file);
        } else if (this.getPropertyScanner().isTranslation(file, this.getScanConfig())) {
            this.newTranslationMatch(file);
        }
    }

    private void newTranslationMatch(File file) {
        URI location;
        File template = this.getPropertyScanner().findTemplate(file, this.getScanConfig());
        if (template == null || !template.isFile()) {
            return;
        }
        Locale locale = this.getPropertyScanner().getLocale(file);
        ProjectLocale projectLocale = this.getOrCreateProjectLocale(locale);
        PropertyFileDescriptor descriptor = (PropertyFileDescriptor)projectLocale.resolveChild(location = this.calculateLocation(file));
        if (descriptor == null) {
            descriptor = this.createDescriptor(projectLocale, location);
        }
        PropertyFile propertyFile = descriptor.loadProperties();
        descriptor.setKeys(propertyFile.getProperties().size());
        Resolvable<?, ?> resolvable = this.getProjectVersion().getTemplate().resolveChild(this.calculateLocation(template));
        if (resolvable instanceof PropertyFileDescriptor) {
            PropertyFileDescriptor templateDescriptor = (PropertyFileDescriptor)resolvable;
            descriptor.setMaster(templateDescriptor);
        }
        descriptor.updatePercentComplete();
    }

    private void newTemplateMatch(File file) {
        PropertyFileDescriptor descriptor;
        boolean exists;
        URI location = this.calculateLocation(file);
        if (this.getProjectVersion().getTemplate() == null) {
            this.getProjectVersion().setTemplate(PropertiesFactory.eINSTANCE.createProjectLocale());
            this.getProjectVersion().getTemplate().setName("template");
            this.getProjectVersion().getChildren().add((Object)this.getProjectVersion().getTemplate());
        }
        boolean bl = exists = (descriptor = (PropertyFileDescriptor)this.getProjectVersion().getTemplate().resolveChild(location)) != null;
        if (!exists) {
            descriptor = this.createDescriptor(this.getProjectVersion().getTemplate(), location);
            this.getProjectVersion().getTemplate().getDescriptors().add((Object)descriptor);
        }
        PropertyFile propertyFile = descriptor.loadProperties();
        descriptor.setKeys(propertyFile.getProperties().size());
        descriptor.updatePercentComplete();
        Locale locale = this.getPropertyScanner().getLocale(file);
        if (locale != null) {
            descriptor.setVariant(locale);
        }
        Map<Locale, File> translations = this.getPropertyScanner().findTranslations(file, this.getScanConfig());
        Set<Map.Entry<Locale, File>> set = translations.entrySet();
        for (Map.Entry<Locale, File> entry : set) {
            URI childURI;
            ProjectLocale projectLocale = this.getOrCreateProjectLocale(entry.getKey());
            PropertyFileDescriptor fileDescriptor = (PropertyFileDescriptor)projectLocale.resolveChild(childURI = this.calculateLocation(entry.getValue()));
            if (fileDescriptor == null) {
                fileDescriptor = this.createDescriptor(projectLocale, childURI);
            }
            fileDescriptor.setMaster(descriptor);
        }
        if (!exists) {
            PropertyResourceUtil.addNewTemplateDescriptor(descriptor, this.getProjectVersion());
        }
    }

    @Override
    public ProjectLocale getOrCreateProjectLocale(Locale locale) {
        ProjectLocale projectLocale = this.getProjectVersion().getProjectLocale(locale);
        if (projectLocale == null) {
            projectLocale = PropertiesFactory.eINSTANCE.createProjectLocale();
            projectLocale.setLocale(locale);
            this.getProjectVersion().getChildren().add((Object)projectLocale);
            PropertyResourceUtil.addNewLocale(projectLocale, this.getProjectVersion());
        }
        return projectLocale;
    }
}

