/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.util.scanner;

import java.io.File;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.jabylon.properties.ScanConfiguration;
import org.jabylon.properties.types.PropertyScanner;
import org.jabylon.properties.util.scanner.PropertyFileAcceptor;
import org.jabylon.properties.util.scanner.SingleFileAcceptor;

public class WorkspaceScanner {
    public void fullScan(PropertyFileAcceptor acceptor, File baseDir, PropertyScanner scanner, ScanConfiguration config, IProgressMonitor monitor) {
        FileSet fs = this.createFileSet(config);
        fs.setDir(baseDir);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Scanning", (int)100);
        String masterLocale = config.getMasterLocale();
        if (masterLocale != null && masterLocale.isEmpty()) {
            masterLocale = null;
        }
        if (baseDir.exists()) {
            DirectoryScanner ds = fs.getDirectoryScanner(new Project());
            subMon.worked(10);
            String[] files = ds.getIncludedFiles();
            subMon.setWorkRemaining(files.length);
            for (String f : files) {
                this.checkCanceled(monitor);
                File file = new File(baseDir, f);
                if (!scanner.isTemplate(file, config.getMasterLocale())) continue;
                subMon.subTask(f);
                acceptor.newMatch(file);
                subMon.worked(1);
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void partialScan(PropertyFileAcceptor acceptor, File baseDir, PropertyScanner scanner, ScanConfiguration config, File singleFile) {
        String[] includes;
        Project antProject = new Project();
        FileSet fs = this.createFileSet(config);
        String[] excludes = fs.mergeExcludes(antProject);
        if (excludes != null) {
            for (String exclude : excludes) {
                if (!SelectorUtils.match((String)WorkspaceScanner.normalizePattern(exclude), (String)singleFile.getPath())) continue;
                return;
            }
        }
        if ((includes = fs.mergeIncludes(antProject)) == null) {
            return;
        }
        for (String include : includes) {
            if (!SelectorUtils.match((String)WorkspaceScanner.normalizePattern(include), (String)singleFile.getPath())) continue;
            if (!baseDir.exists()) break;
            acceptor.newMatch(singleFile);
            break;
        }
    }

    public boolean partialScan(File baseDir, PropertyScanner scanner, ScanConfiguration config, File singleFile) {
        SingleFileAcceptor acceptor = new SingleFileAcceptor();
        this.partialScan(acceptor, baseDir, scanner, config, singleFile);
        return acceptor.isMatch();
    }

    private FileSet createFileSet(ScanConfiguration config) {
        PatternSet.NameEntry entry;
        FileSet fs = new FileSet();
        fs.setProject(new Project());
        for (String exclude : config.getExcludes()) {
            entry = fs.createExclude();
            entry.setName(exclude);
        }
        for (String include : config.getIncludes()) {
            entry = fs.createInclude();
            entry.setName(include);
        }
        return fs;
    }

    private static String normalizePattern(String p) {
        return p.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }
}

