/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.xliff;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.xliff.PropertyWrapper;
import org.jabylon.properties.xliff.XliffXMLConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XliffReader
implements XliffXMLConstants {
    private XliffReader() {
    }

    public static final PropertyWrapper read(InputStream in, String encoding) throws IOException, SAXException {
        DocumentBuilder builder = XliffReader.getDocumentBuilder();
        Element root = builder.parse(in).getDocumentElement();
        Element fileElement = (Element)XliffReader.getChildNodeByTagName(root, "file");
        if (fileElement == null) {
            throw new SAXException("Element <file> null.");
        }
        Locale locale = XliffReader.getTargetLocale(fileElement);
        Element bodyElement = (Element)XliffReader.getChildNodeByTagName(fileElement, "body");
        Map<String, Property> properties = XliffReader.readProperties(bodyElement);
        return new PropertyWrapper(locale, properties);
    }

    private static Map<String, Property> readProperties(Element bodyElement) {
        NodeList transUnits = bodyElement.getElementsByTagName("trans-unit");
        HashMap<String, Property> ret = new HashMap<String, Property>();
        if (transUnits == null) {
            return ret;
        }
        for (int i = 0; i < transUnits.getLength(); ++i) {
            String value;
            String key;
            Element transUnit = (Element)transUnits.item(i);
            Node targetElement = XliffReader.getChildNodeByTagName(transUnit, "target");
            if (targetElement == null || !XliffReader.hasValue(key = transUnit.getAttribute("id")) || !XliffReader.hasValue(value = XliffReader.getTranslationFromTargetElement(targetElement))) continue;
            Property property = XliffReader.newProperty(key, value);
            ret.put(property.getKey(), property);
        }
        return ret;
    }

    private static String getTranslationFromTargetElement(Node targetElement) {
        String value = XliffReader.getNodeValue(targetElement);
        if (XliffReader.hasValue(value)) {
            return value;
        }
        Node mrkElement = XliffReader.getChildNodeByTagName(targetElement, "mrk");
        if (mrkElement == null) {
            return null;
        }
        return XliffReader.getNodeValue(mrkElement);
    }

    private static Property newProperty(String key, String value) {
        Property property = PropertiesFactory.eINSTANCE.createProperty();
        property.setKey(key);
        property.setValue(value);
        return property;
    }

    private static Locale getTargetLocale(Element fileElement) throws IOException {
        String targetLanguage = fileElement.getAttribute("target-language");
        if (targetLanguage.indexOf("_") != -1) {
            return XliffReader.parseLocale(targetLanguage, "_");
        }
        if (targetLanguage.indexOf("-") != -1) {
            return XliffReader.parseLocale(targetLanguage, "-");
        }
        return new Locale(targetLanguage);
    }

    private static Locale parseLocale(String targetLanguage, String split) {
        String[] locale = targetLanguage.split(split);
        if (locale.length == 3) {
            return new Locale(locale[0], locale[1], locale[2]);
        }
        if (locale.length == 2) {
            return new Locale(locale[0], locale[1]);
        }
        return new Locale(locale[0]);
    }

    private static Node getChildNodeByTagName(Node node, String tagName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!tagName.equals(child.getNodeName())) continue;
            return child;
        }
        return null;
    }

    private static String getNodeValue(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue().trim();
        }
        return "";
    }

    private static boolean hasValue(String value) {
        return value != null && !"".equals(value);
    }

    private static DocumentBuilder getDocumentBuilder() throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }
}

