/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.properties.xliff;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jabylon.properties.Property;
import org.jabylon.properties.xliff.PropertyWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XliffWriter {
    private XliffWriter() {
    }

    public static final void write(OutputStream out, PropertyWrapper filteredSource, PropertyWrapper filteredTarget, String encoding) throws IOException {
        Element rootElement = XliffWriter.writeDocument(filteredSource, filteredTarget);
        Transformer transformer = XliffWriter.getTransformer();
        StreamResult result = new StreamResult(out);
        DOMSource domSource = new DOMSource(rootElement);
        try {
            transformer.transform(domSource, result);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    private static Element writeDocument(PropertyWrapper filteredSource, PropertyWrapper filteredTarget) throws IOException {
        Document doc = XliffWriter.createDocument();
        Element rootElement = XliffWriter.createRootElement(doc);
        Element fileElement = XliffWriter.createFileElement(doc, rootElement, filteredSource.getLocale(), filteredTarget.getLocale());
        Element bodyElement = doc.createElement("body");
        Set<Map.Entry<String, Property>> targetEntries = filteredTarget.getProperties().entrySet();
        Map<String, Property> sourceEntries = filteredSource.getProperties();
        for (Map.Entry<String, Property> targetEntry : targetEntries) {
            String key = targetEntry.getKey();
            String targetValue = XliffWriter.getPropertyValueNullAsEmpty(targetEntry.getValue());
            String sourceValue = XliffWriter.getPropertyValueNullAsEmpty(sourceEntries.get(key));
            bodyElement.appendChild(XliffWriter.createTransUnitElement(doc, key, sourceValue, targetValue));
        }
        fileElement.appendChild(bodyElement);
        rootElement.appendChild(fileElement);
        return rootElement;
    }

    private static Element createFileElement(Document doc, Element rootElement, Locale source, Locale target) {
        Element fileElement = doc.createElement("file");
        fileElement.setAttribute("datatype", "plaintext");
        fileElement.setAttribute("source-language", XliffWriter.getLanguageCode(source));
        fileElement.setAttribute("target-language", XliffWriter.getLanguageCode(target));
        fileElement.setAttribute("original", "properties");
        return fileElement;
    }

    private static Element createRootElement(Document doc) {
        Element rootElement = doc.createElement("xliff");
        rootElement.setAttribute("xmlns", "urn:oasis:names:tc:xliff:document:1.2");
        rootElement.setAttribute("version", "1.2");
        return rootElement;
    }

    protected static final Element createTransUnitElement(Document doc, String key, String sourceValue, String targetValue) {
        Element transUnitElement = doc.createElement("trans-unit");
        Element sourceElement = doc.createElement("source");
        Element targetElement = doc.createElement("target");
        sourceElement.setTextContent(sourceValue);
        targetElement.setTextContent(targetValue);
        transUnitElement.appendChild(sourceElement);
        transUnitElement.appendChild(targetElement);
        transUnitElement.setAttribute("id", key);
        return transUnitElement;
    }

    private static Document createDocument() throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    private static Transformer getTransformer() throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
    }

    private static String getPropertyValueNullAsEmpty(Property value) {
        return value == null ? "" : (value.getValue() != null ? value.getValue() : "");
    }

    private static String getLanguageCode(Locale locale) {
        if (locale == null) {
            return "en";
        }
        return locale.toLanguageTag();
    }
}

