/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.jabylon.rest.ui.wicket.JabylonApplication;

public class JabylonFilter
extends WicketFilter
implements IWebApplicationFactory {
    private String rootRedirect = null;

    protected IWebApplicationFactory getApplicationFactory() {
        return this;
    }

    public WebApplication createApplication(WicketFilter filter) {
        return new JabylonApplication();
    }

    public void destroy(WicketFilter filter) {
    }

    protected String getFilterPathFromConfig(FilterConfig filterConfig) {
        ServletContext context = filterConfig.getServletContext();
        String path = "";
        if (context != null) {
            path = context.getContextPath();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.rootRedirect == null && request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            this.rootRedirect = this.getFilterPath();
            if (this.rootRedirect == null) {
                this.rootRedirect = "";
            }
            if (this.rootRedirect.endsWith("/")) {
                this.rootRedirect = this.rootRedirect.substring(0, this.rootRedirect.length() - 1);
            }
            if (!this.rootRedirect.isEmpty() && !this.rootRedirect.startsWith("/")) {
                this.rootRedirect = "/" + this.rootRedirect;
            }
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String pathInfo = httpRequest.getRequestURI();
            if (this.rootRedirect.equals(pathInfo)) {
                httpResponse.sendRedirect(this.rootRedirect + "/");
                return;
            }
        }
        super.doFilter(request, response, chain);
    }
}

