/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.model;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.jabylon.rest.ui.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEMFModel<T extends CDOObject, R>
implements IModel<R> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEMFModel.class);
    protected Supplier<T> modelSupplier;
    protected long id;

    public AbstractEMFModel(T model) {
        this.id = CDOIDUtil.getLong((CDOID)model.cdoID());
        this.modelSupplier = Suppliers.memoize(new LoadingSupplier<T>(model));
    }

    protected T getDomainObject() {
        CDOObject t = (CDOObject)this.modelSupplier.get();
        if (t == null) {
            LOGGER.warn("Lost for some reason the model supplier. Trying to recover");
            this.modelSupplier = Suppliers.memoize(new LoadingSupplier(this.id));
            t = (CDOObject)this.modelSupplier.get();
            LOGGER.warn("Recovered to " + t);
        }
        return (T)t;
    }

    protected void setDomainObject(T domainObject) {
        this.modelSupplier = Suppliers.memoize((Supplier)Suppliers.ofInstance(domainObject));
    }

    public void detach() {
        this.modelSupplier = Suppliers.memoize(new LoadingSupplier(this.id));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractEMFModel) {
            AbstractEMFModel other = (AbstractEMFModel)obj;
            return other.id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }

    private static final class LoadingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient T instance;
        private LookupFunction<T> function;
        private long id;

        public LoadingSupplier(T instance) {
            this.instance = instance;
            this.function = new LookupFunction();
        }

        public LoadingSupplier(long id) {
            this.instance = null;
            this.id = id;
            this.function = new LookupFunction();
        }

        public T get() {
            if (this.instance == null) {
                this.instance = this.function.apply(this.id);
            }
            return this.instance;
        }
    }

    private static final class LookupFunction<X>
    implements Serializable,
    Function<Long, X> {
        private static final long serialVersionUID = -7243181664341900603L;

        private LookupFunction() {
        }

        public X apply(Long from) {
            CDOID id = CDOIDUtil.createLong((long)from);
            CDOObject cdoObject = Activator.getDefault().getRepositoryLookup().resolve(id);
            return (X)cdoObject;
        }
    }
}

