/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.rest.ui.model.EObjectModel;

public class ComplexEObjectListDataProvider<R extends CDOObject>
implements IDataProvider<R>,
IModel<List<R>> {
    private static final long serialVersionUID = 1L;
    private String featureName;
    private IModel<? extends CDOObject> model;

    public ComplexEObjectListDataProvider(IModel<? extends CDOObject> model, EStructuralFeature feature) {
        this.model = model;
        this.featureName = feature.getName();
    }

    public Iterator<? extends R> iterator(long arg0, long arg1) {
        CDOObject parent = (CDOObject)this.model.getObject();
        EStructuralFeature feature = parent.eClass().getEStructuralFeature(this.featureName);
        List result = (List)parent.eGet(feature);
        return result.subList((int)arg0, (int)arg1).iterator();
    }

    public long size() {
        CDOObject parent = (CDOObject)this.model.getObject();
        EStructuralFeature feature = parent.eClass().getEStructuralFeature(this.featureName);
        List result = (List)parent.eGet(feature);
        return result.size();
    }

    public IModel<R> model(R object) {
        return new EObjectModel<R>(object);
    }

    public void detach() {
        this.model.detach();
    }

    public List<R> getObject() {
        CDOObject parent = (CDOObject)this.model.getObject();
        EStructuralFeature feature = parent.eClass().getEStructuralFeature(this.featureName);
        List result = (List)parent.eGet(feature);
        return result;
    }

    public void setObject(List<R> object) {
        CDOObject parent = (CDOObject)this.model.getObject();
        EStructuralFeature feature = parent.eClass().getEStructuralFeature(this.featureName);
        parent.eSet(feature, new ArrayList<R>(object));
    }

    public IModel<? extends CDOObject> getModel() {
        return this.model;
    }
}

