/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.jabylon.rest.ui.model.BundleClassloader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiAwareBundleStringResourceLoader
implements IStringResourceLoader {
    private final BundleContext context;
    private LoadingCache<Integer, ClassLoader> cache;
    private Logger logger = LoggerFactory.getLogger(OSGiAwareBundleStringResourceLoader.class);
    private static final ResourceBundle.Control CONTROL = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);

    public OSGiAwareBundleStringResourceLoader() {
        this.context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, ClassLoader>(){

            public ClassLoader load(Integer key) throws Exception {
                Bundle bundle = OSGiAwareBundleStringResourceLoader.this.context.getBundle((long)key.intValue());
                String bundleName = (String)bundle.getHeaders().get("Bundle-Localisation");
                if (bundleName == null) {
                    bundleName = "OSGI-INF/l10n/bundle";
                }
                String prefix = "/" + bundleName.substring(0, bundleName.lastIndexOf(47));
                Enumeration entries = bundle.findEntries(prefix, "*.properties", false);
                List<URL> urls = Collections.emptyList();
                if (entries != null) {
                    urls = new ArrayList();
                    while (entries.hasMoreElements()) {
                        URL url = (URL)entries.nextElement();
                        urls.add(url);
                    }
                }
                return new BundleClassloader(prefix, urls);
            }
        });
    }

    public final String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        try {
            if (key.startsWith("%")) {
                int keyStart;
                int bundleId;
                Bundle bundle;
                String bundleName;
                if (locale == null) {
                    Locale locale2 = locale = Session.exists() ? Session.get().getLocale() : Locale.getDefault();
                }
                if ((bundleName = (String)(bundle = this.context.getBundle((long)(bundleId = Integer.parseInt(key.substring(1, keyStart = key.indexOf("|")))))).getHeaders().get("Bundle-Localisation")) == null) {
                    bundleName = "OSGI-INF/l10n/bundle";
                }
                return ResourceBundle.getBundle(bundleName, locale, (ClassLoader)this.cache.get((Object)bundleId), CONTROL).getString(key.substring(keyStart + 1));
            }
            if (key.startsWith("|")) {
                return key.substring(1);
            }
            return null;
        }
        catch (MissingResourceException e) {
            return null;
        }
        catch (ExecutionException e) {
            this.logger.warn("Failed to create classloader for key " + key, (Throwable)e);
            return null;
        }
    }

    public final String loadStringResource(Component component, String key, Locale locale, String style, String variation) {
        return this.loadStringResource((Class)null, key, locale, style, variation);
    }
}

