/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.navbar;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.jabylon.rest.ui.navbar.LogoutLink;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.rest.ui.security.LoginPage;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.PanelFactory;
import org.jabylon.rest.ui.wicket.config.SettingsPage;
import org.jabylon.users.User;

public class LoginPanel<T>
extends BasicPanel<T> {
    private static final String LOGOUT_KEY = "logout.link.title";
    static final String LOGIN_KEY = "login.link.title";
    private static final long serialVersionUID = 1L;
    private BookmarkablePageLink<String> userLink;

    public LoginPanel(String id, IModel<T> object, PageParameters parameters) {
        super(id, object, parameters);
        String username = "Anonymous";
        Session theSession = this.getSession();
        PageParameters userLinkParams = new PageParameters();
        this.userLink = new BookmarkablePageLink("user-link", SettingsPage.class, userLinkParams);
        if (theSession instanceof CDOAuthenticatedSession) {
            CDOAuthenticatedSession session = (CDOAuthenticatedSession)theSession;
            User user = session.getUser();
            if (user != null) {
                LogoutLink link = new LogoutLink("link");
                link.add(new Component[]{new Label("link-label", (IModel)new StringResourceModel(LOGOUT_KEY, (Component)this, null, new Object[0]))});
                this.add(new Component[]{link});
                userLinkParams.set(0, (Object)"security");
                userLinkParams.set(1, (Object)"users");
                userLinkParams.set(2, (Object)user.getName());
                username = user.getDisplayName();
                if (username == null) {
                    username = user.getName();
                }
                this.userLink.setVisible(true);
            } else {
                BookmarkablePageLink link = new BookmarkablePageLink("link", LoginPage.class);
                link.add(new Component[]{new Label("link-label", (IModel)new StringResourceModel(LOGIN_KEY, (Component)this, null, new Object[0]))});
                this.add(new Component[]{link});
                this.userLink.setVisible(false);
            }
        }
        this.userLink.setBody((IModel)Model.of((Serializable)((Object)username)));
        this.add(new Component[]{this.userLink});
    }

    public static class LoginPanelFactory
    implements PanelFactory<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public Panel createPanel(PageParameters params, IModel<Object> input, String id) {
            return new LoginPanel<Object>(id, input, params);
        }
    }
}

