/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.navbar;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.PanelFactory;
import org.jabylon.rest.ui.wicket.pages.WelcomePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavbarPanel<T>
extends BasicPanel<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NavbarPanel.class);

    public NavbarPanel(String id, IModel<T> model, PageParameters parameters) {
        super(id, model, parameters);
        this.add(new Component[]{new BookmarkablePageLink("jabylon", WelcomePage.class)});
        Map<PanelFactory, Boolean> data = this.loadNavBarExtensions();
        ArrayList<PanelFactory> items = new ArrayList<PanelFactory>();
        ArrayList<PanelFactory> rightAligned = new ArrayList<PanelFactory>();
        for (Map.Entry<PanelFactory, Boolean> entry : data.entrySet()) {
            if (entry.getValue().booleanValue()) {
                rightAligned.add(entry.getKey());
                continue;
            }
            items.add(entry.getKey());
        }
        ListView<PanelFactory> listView = new ListView<PanelFactory>("items", items){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<PanelFactory> item) {
                Panel newPanel = ((PanelFactory)item.getModelObject()).createPanel(NavbarPanel.this.getPageParameters(), NavbarPanel.this.getModel(), "content");
                if (newPanel == null) {
                    item.add(new Component[]{new Label("content", "NONE")});
                } else {
                    item.add(new Component[]{newPanel});
                }
            }
        };
        listView.setRenderBodyOnly(true);
        this.add(new Component[]{listView});
        ListView<PanelFactory> rightListView = new ListView<PanelFactory>("right-items", rightAligned){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<PanelFactory> item) {
                Panel newPanel = ((PanelFactory)item.getModelObject()).createPanel(NavbarPanel.this.getPageParameters(), NavbarPanel.this.getModel(), "content");
                if (newPanel == null) {
                    item.add(new Component[]{new Label("content", "NONE")});
                } else {
                    item.add(new Component[]{newPanel});
                }
            }
        };
        rightListView.setRenderBodyOnly(true);
        this.add(new Component[]{rightListView});
    }

    private Map<PanelFactory, Boolean> loadNavBarExtensions() {
        IConfigurationElement[] configurationElements;
        LinkedHashMap<PanelFactory, Boolean> extensions = new LinkedHashMap<PanelFactory, Boolean>();
        for (IConfigurationElement element : configurationElements = RegistryFactory.getRegistry().getConfigurationElementsFor("org.jabylon.rest.ui.navbarItem")) {
            try {
                PanelFactory extension = (PanelFactory)element.createExecutableExtension("panel");
                String pullRight = element.getAttribute("pullRight");
                if (pullRight != null && Boolean.valueOf(pullRight).booleanValue()) {
                    extensions.put(extension, true);
                    continue;
                }
                extensions.put(extension, false);
            }
            catch (CoreException e) {
                logger.error("Failed to load extension " + element, (Throwable)e);
            }
        }
        return extensions;
    }
}

