/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.security;

import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.UnauthorizedActionException;
import org.apache.wicket.request.component.IRequestableComponent;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.rest.ui.security.LoginPage;
import org.jabylon.rest.ui.security.RestrictedComponent;
import org.jabylon.security.CommonPermissions;
import org.jabylon.users.User;

public class PermissionBasedAuthorizationStrategy
implements IAuthorizationStrategy {
    public <T extends IRequestableComponent> boolean isInstantiationAuthorized(Class<T> componentClass) {
        return true;
    }

    public boolean isActionAuthorized(Component component, Action action) {
        if (component instanceof RestrictedComponent) {
            RestrictedComponent restricted = (RestrictedComponent)component;
            String permission = restricted.getRequiredPermission();
            if (permission == null) {
                return true;
            }
            CDOAuthenticatedSession session = (CDOAuthenticatedSession)CDOAuthenticatedSession.get();
            if (session.getUser() == null) {
                User anonymousUser = session.getAnonymousUser();
                if (anonymousUser == null) {
                    return false;
                }
                boolean allowed = anonymousUser.hasPermission(permission);
                if (allowed) {
                    return true;
                }
                throw new RestartResponseAtInterceptPageException(LoginPage.class);
            }
            boolean allowed = session.getUser().hasPermission(permission);
            if (allowed) {
                return true;
            }
            if (CommonPermissions.isEditRequest((String)permission)) {
                throw new UnauthorizedActionException(component, action);
            }
            return false;
        }
        return true;
    }
}

