/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.util;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.eclipse.emf.common.util.URI;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Resolvable;
import org.jabylon.rest.ui.util.WebContextUrlResourceReference;

public class WicketUtil {
    public static PageParameters buildPageParametersFor(Resolvable<?, ?> r) {
        PageParameters params = new PageParameters();
        ArrayDeque<String> segments = new ArrayDeque<String>();
        for (Resolvable part = r; part != null; part = part.getParent()) {
            String name = part.getName();
            if (name == null) continue;
            segments.push(name);
        }
        int count = 0;
        for (String string : segments) {
            params.set(count++, (Object)string);
        }
        return params;
    }

    public static PageParameters buildPageParametersFor(URI uri) {
        PageParameters params = new PageParameters();
        ArrayList segments = new ArrayList(uri.segmentsList());
        int count = 0;
        for (String string : segments) {
            params.set(count++, (Object)string);
        }
        return params;
    }

    public static String getContextPath() {
        String path = RequestCycle.get().getRequest().getFilterPath();
        if (path == null || path.isEmpty()) {
            return "";
        }
        return path;
    }

    public static ResourceReference getIconForLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        String iconName = "";
        iconName = locale.getCountry() != null && locale.getCountry().length() > 0 ? locale.getCountry().toLowerCase() : WicketUtil.derriveCountry(locale);
        String url = "img/flags/gif/{0}.gif";
        url = MessageFormat.format(url, iconName);
        WebContextUrlResourceReference ref = new WebContextUrlResourceReference(url);
        return ref;
    }

    public static String derriveCountry(Locale locale) {
        String language = locale.getLanguage();
        if ("da".equals(language)) {
            return "dk";
        }
        if ("ja".equals(language)) {
            return "jp";
        }
        if ("uk".equals(language)) {
            return "ua";
        }
        if ("eu".equals(language)) {
            return null;
        }
        if ("he".equals(language)) {
            return "il";
        }
        if ("iw".equals(language)) {
            return "il";
        }
        if ("el".equals(language)) {
            return "gr";
        }
        if ("ko".equals(language)) {
            return "kr";
        }
        if ("te".equals(language)) {
            return "in";
        }
        if ("ca".equals(language)) {
            return "catalonia";
        }
        if ("zh".equals(language)) {
            return "cn";
        }
        if ("en".equals(language)) {
            return "gb";
        }
        return language.toLowerCase();
    }

    public static Locale getUserLocale() {
        return WicketUtil.getUserLocale(RequestCycle.get().getRequest());
    }

    public static Locale getUserLocale(Request request) {
        return request.getLocale();
    }

    public static Locale getLocaleFromString(String locale) {
        return (Locale)PropertiesFactory.eINSTANCE.createFromString(PropertiesPackage.Literals.LOCALE, locale);
    }
}

