/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.DefaultExceptionMapper;
import org.apache.wicket.Session;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomExceptionMapper
extends DefaultExceptionMapper {
    private static final Logger LOG = LoggerFactory.getLogger(CustomExceptionMapper.class);

    public IRequestHandler map(Exception e) {
        if (e instanceof ObjectNotFoundException) {
            Request request = RequestCycle.get().getRequest();
            Url url = request.getUrl();
            List parameters = url.getQueryParameters();
            boolean redirected = false;
            for (Url.QueryParameter queryParameter : parameters) {
                if (!queryParameter.getValue().isEmpty() || !queryParameter.getName().matches("\\d+")) continue;
                url.removeQueryParameters(queryParameter.getName());
                LOG.error("Detected request to expired CDO ID. Attempting redirect to " + url.toString(), (Throwable)e);
                Session.get().error((Serializable)((Object)"Sorry, this page content has expired. Please try again"));
                redirected = true;
                break;
            }
            if (redirected) {
                return new RedirectRequestHandler("/" + url.toString());
            }
        }
        return super.map(e);
    }
}

