/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket;

import java.nio.charset.Charset;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.IProvider;
import org.eclipse.emf.common.util.URI;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.EMFFactoryConverter;
import org.jabylon.rest.ui.model.OSGiAwareBundleStringResourceLoader;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.rest.ui.security.LoginPage;
import org.jabylon.rest.ui.security.PermissionBasedAuthorizationStrategy;
import org.jabylon.rest.ui.util.PageProvider;
import org.jabylon.rest.ui.wicket.CustomExceptionMapper;
import org.jabylon.rest.ui.wicket.CustomInternalErrorPage;
import org.jabylon.rest.ui.wicket.CustomWebRequest;
import org.jabylon.rest.ui.wicket.ResouceAwareMountedMapper;
import org.jabylon.rest.ui.wicket.components.AjaxFeedbackListener;
import org.jabylon.rest.ui.wicket.config.SettingsPage;
import org.jabylon.rest.ui.wicket.injector.OSGiInjector;
import org.jabylon.rest.ui.wicket.pages.ResourcePage;
import org.jabylon.rest.ui.wicket.pages.StartupPage;
import org.jabylon.rest.ui.wicket.pages.WelcomePage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabylonApplication
extends AuthenticatedWebApplication {
    private ServiceTracker pageTracker;
    private static Logger logger = LoggerFactory.getLogger(JabylonApplication.class);

    public Class<? extends Page> getHomePage() {
        return WelcomePage.class;
    }

    public WebRequest newWebRequest(HttpServletRequest servletRequest, String filterPath) {
        return new CustomWebRequest(servletRequest, filterPath);
    }

    protected void init() {
        super.init();
        this.mount((IRequestMapper)new ResouceAwareMountedMapper("/", StartupPage.class));
        this.getRequestCycleSettings().setResponseRequestEncoding("UTF-8");
        this.getMarkupSettings().setDefaultMarkupEncoding("UTF-8");
        OSGiInjector injector = new OSGiInjector((Application)this);
        this.getBehaviorInstantiationListeners().add((Object)injector);
        this.getResourceSettings().getStringResourceLoaders().add(new OSGiAwareBundleStringResourceLoader());
        this.getApplicationSettings().setInternalErrorPage(CustomInternalErrorPage.class);
        this.getComponentInstantiationListeners().add((Object)injector);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new PermissionBasedAuthorizationStrategy());
        this.getAjaxRequestTargetListeners().add((Object)new AjaxFeedbackListener());
        final BundleContext bundleContext = Activator.getDefault().getContext();
        this.pageTracker = new ServiceTracker(bundleContext, PageProvider.class, new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference ref) {
                PageProvider service = (PageProvider)bundleContext.getService(ref);
                Object pathObject = ref.getProperty("mountPath");
                if (pathObject instanceof String) {
                    String path = (String)pathObject;
                    Class<? extends Page> pageClass = service.getPageClass();
                    if (pageClass == ResourcePage.class) {
                        ThreadContext.setApplication((Application)JabylonApplication.this);
                        ThreadContext.setSession((Session)new WebSession(JabylonApplication.this.createFakeRequest()));
                        JabylonApplication.this.initMainPages();
                    }
                    logger.info("Mounting new page {} at {}", pageClass, (Object)path);
                    JabylonApplication.this.mount((IRequestMapper)new ResouceAwareMountedMapper(path, pageClass));
                } else {
                    logger.warn("Ignored Page {} because it was registered with invalid path property '{}'", (Object)service, pathObject);
                }
                return service;
            }

            public void modifiedService(ServiceReference arg0, Object arg1) {
            }

            public void removedService(ServiceReference ref, Object service) {
                Object pathObject = ref.getProperty("mountPath");
                if (pathObject instanceof String) {
                    String path = (String)pathObject;
                    ThreadContext.setApplication((Application)JabylonApplication.this);
                    ThreadContext.setSession((Session)new WebSession(JabylonApplication.this.createFakeRequest()));
                    JabylonApplication.this.unmount(path);
                }
            }
        });
        this.pageTracker.open();
    }

    private void initMainPages() {
        this.unmount("/");
        this.mount((IRequestMapper)new ResouceAwareMountedMapper("/login", LoginPage.class));
        this.mount((IRequestMapper)new ResouceAwareMountedMapper("/settings", SettingsPage.class));
    }

    protected IConverterLocator newConverterLocator() {
        ConverterLocator converterLocator = new ConverterLocator();
        converterLocator.set(URI.class, new EMFFactoryConverter(PropertiesPackage.Literals.URI.getName()));
        converterLocator.set(Locale.class, new EMFFactoryConverter(PropertiesPackage.Literals.LOCALE.getName()));
        return converterLocator;
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return CDOAuthenticatedSession.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return LoginPage.class;
    }

    public IProvider<IExceptionMapper> getExceptionMapperProvider() {
        return new CustomExceptionMapperProvider();
    }

    Request createFakeRequest() {
        return new Request(){

            public Url getUrl() {
                return new Url();
            }

            public Locale getLocale() {
                return Locale.getDefault();
            }

            public Object getContainerRequest() {
                return null;
            }

            public Url getClientUrl() {
                return null;
            }

            public Charset getCharset() {
                return null;
            }
        };
    }

    private static class CustomExceptionMapperProvider
    implements IProvider<IExceptionMapper> {
        private CustomExceptionMapperProvider() {
        }

        public IExceptionMapper get() {
            return new CustomExceptionMapper();
        }
    }
}

