/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.components;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.jabylon.rest.ui.util.GlobalResources;

public class ClientSideTabbedPanel<T extends ITab>
extends Panel {
    private List<WebMarkupContainer> tabContents;
    private IModel<Integer> activeTab = Model.of((Serializable)Integer.valueOf(0));
    private static final long serialVersionUID = 1L;

    public ClientSideTabbedPanel(final String id, List<T> tabs, boolean vertical, String persistenceKey) {
        super(id);
        WebMarkupContainer tabbable = new WebMarkupContainer("tabbable");
        if (vertical) {
            tabbable.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" tabs-left"))});
        }
        if (persistenceKey != null) {
            tabbable.add(new Behavior[]{new AttributeModifier("data-tabsheet", (Serializable)((Object)persistenceKey))});
        }
        this.add(new Component[]{tabbable});
        ListView listView = new ListView<T>("tab-handles", tabs){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                int index = item.getIndex();
                if (index == (Integer)ClientSideTabbedPanel.this.activeTab.getObject()) {
                    item.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" active"))});
                }
                item.add(new Component[]{new ExternalLink("link", (IModel)Model.of((Serializable)((Object)("#" + id + index))), ((ITab)item.getModelObject()).getTitle())});
            }
        };
        listView.setReuseItems(true);
        this.tabContents = new ArrayList<WebMarkupContainer>();
        ListView tabContent = new ListView<T>("tab-content", tabs){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                int index = item.getIndex();
                if (index == (Integer)ClientSideTabbedPanel.this.activeTab.getObject()) {
                    item.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" active"))});
                }
                item.setMarkupId(id + index);
                Object object = item.getDefaultModelObject();
                if (object instanceof ITab) {
                    ITab tab = (ITab)object;
                    WebMarkupContainer panel = tab.getPanel("content");
                    panel.setOutputMarkupId(true);
                    ClientSideTabbedPanel.this.tabContents.add(panel);
                    item.add(new Component[]{panel});
                }
            }
        };
        tabContent.setReuseItems(true);
        tabbable.add(new Component[]{tabContent});
        tabbable.add(new Component[]{listView});
    }

    public ClientSideTabbedPanel(String id, List<T> tabs) {
        this(id, tabs, false, null);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_PERSISTENT_TABS));
    }

    public List<WebMarkupContainer> getTabContents() {
        return this.tabContents;
    }

    public void setActiveTab(IModel<Integer> activeIndex) {
        this.activeTab = activeIndex;
    }

    public void setActiveTab(int activeIndex) {
        this.activeTab = Model.of((Serializable)Integer.valueOf(activeIndex));
    }
}

