/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.components;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class CustomFeedbackPanel
extends Panel
implements IFeedback {
    private static final long serialVersionUID = 1L;
    private final MessageListView messageListView;

    public CustomFeedbackPanel(String id) {
        this(id, null);
    }

    public CustomFeedbackPanel(String id, IFeedbackMessageFilter filter) {
        super(id);
        WebMarkupContainer messagesContainer = new WebMarkupContainer("feedbackul"){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(CustomFeedbackPanel.this.anyMessage());
            }
        };
        this.add(new Component[]{messagesContainer});
        this.messageListView = new MessageListView("messages");
        this.messageListView.setVersioned(false);
        messagesContainer.add(new Component[]{this.messageListView});
        if (filter != null) {
            this.setFilter(filter);
        }
    }

    public final boolean anyErrorMessage() {
        return this.anyMessage(400);
    }

    public final boolean anyMessage() {
        return this.anyMessage(0);
    }

    public final boolean anyMessage(int level) {
        List<FeedbackMessage> msgs = this.getCurrentMessages();
        for (FeedbackMessage msg : msgs) {
            if (!msg.isLevel(level)) continue;
            return true;
        }
        return false;
    }

    public final FeedbackMessagesModel getFeedbackMessagesModel() {
        return (FeedbackMessagesModel)this.messageListView.getDefaultModel();
    }

    public final IFeedbackMessageFilter getFilter() {
        return this.getFeedbackMessagesModel().getFilter();
    }

    public final Comparator<FeedbackMessage> getSortingComparator() {
        return this.getFeedbackMessagesModel().getSortingComparator();
    }

    public boolean isVersioned() {
        return false;
    }

    public final CustomFeedbackPanel setFilter(IFeedbackMessageFilter filter) {
        this.getFeedbackMessagesModel().setFilter(filter);
        return this;
    }

    public final CustomFeedbackPanel setMaxMessages(int maxMessages) {
        this.messageListView.setViewSize(maxMessages);
        return this;
    }

    public final CustomFeedbackPanel setSortingComparator(Comparator<FeedbackMessage> sortingComparator) {
        this.getFeedbackMessagesModel().setSortingComparator(sortingComparator);
        return this;
    }

    protected String getCSSClass(FeedbackMessage message) {
        int level = message.getLevel();
        switch (level) {
            case 250: {
                return "alert-success alert alert-block ";
            }
            case 400: {
                return "alert-error alert alert-block ";
            }
            case 500: {
                return "alert-error alert alert-block ";
            }
            case 200: {
                return "alert-info alert alert-block ";
            }
            case 300: {
                return "alert alert-block ";
            }
        }
        return "alert-info alert alert-block ";
    }

    protected IModel<String> getMessageKind(FeedbackMessage message) {
        int level = message.getLevel();
        String key = null;
        switch (level) {
            case 250: {
                key = "success";
                break;
            }
            case 400: {
                key = "error";
                break;
            }
            case 500: {
                key = "fatal";
                break;
            }
            case 200: {
                key = "info";
                break;
            }
            case 300: {
                key = "warning";
                break;
            }
        }
        return new StringResourceModel(key, (Component)this, null, new Object[0]);
    }

    protected final List<FeedbackMessage> getCurrentMessages() {
        List messages = this.messageListView.getModelObject();
        return Collections.unmodifiableList(messages);
    }

    protected FeedbackMessagesModel newFeedbackMessagesModel() {
        return new FeedbackMessagesModel((Component)this);
    }

    protected Component newMessageDisplayComponent(String id, FeedbackMessage message) {
        Serializable serializable = message.getMessage();
        Label label = new Label(id, serializable == null ? "" : serializable.toString());
        label.setEscapeModelStrings(this.getEscapeModelStrings());
        return label;
    }

    private final class MessageListView
    extends ListView<FeedbackMessage> {
        private static final long serialVersionUID = 1L;

        public MessageListView(String id) {
            super(id);
            this.setDefaultModel((IModel)CustomFeedbackPanel.this.newFeedbackMessagesModel());
        }

        protected IModel<FeedbackMessage> getListItemModel(final IModel<? extends List<FeedbackMessage>> listViewModel, final int index) {
            return new AbstractReadOnlyModel<FeedbackMessage>(){
                private static final long serialVersionUID = 1L;

                public FeedbackMessage getObject() {
                    if (index >= ((List)listViewModel.getObject()).size()) {
                        return null;
                    }
                    return (FeedbackMessage)((List)listViewModel.getObject()).get(index);
                }
            };
        }

        protected void populateItem(final ListItem<FeedbackMessage> listItem) {
            Model<String> replacementModel = new Model<String>(){
                private static final long serialVersionUID = 1L;

                public String getObject() {
                    return CustomFeedbackPanel.this.getCSSClass((FeedbackMessage)listItem.getModelObject());
                }
            };
            FeedbackMessage message = (FeedbackMessage)listItem.getModelObject();
            message.markRendered();
            Component label = CustomFeedbackPanel.this.newMessageDisplayComponent("message", message);
            AttributeModifier levelModifier = new AttributeModifier("class", (IModel)replacementModel);
            listItem.add(new Behavior[]{levelModifier});
            listItem.add(new Component[]{label});
            listItem.add(new Component[]{new Label("message-type", CustomFeedbackPanel.this.getMessageKind(message))});
        }
    }
}

