/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config;

import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.jabylon.rest.ui.security.CDOAuthenticatedSession;
import org.jabylon.rest.ui.security.LoginPage;
import org.jabylon.rest.ui.wicket.config.ConfigSection;
import org.jabylon.users.User;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractConfigSection<T>
implements ConfigSection<T> {
    private static final long serialVersionUID = 1L;
    private IModel<T> model;

    public T getDomainObject() {
        if (this.model == null) {
            return null;
        }
        return (T)this.model.getObject();
    }

    public IModel<T> getModel() {
        return this.model;
    }

    @Override
    public void apply(Preferences config) {
    }

    @Override
    public boolean isVisible(IModel<T> input, Preferences config) {
        this.model = input;
        CDOAuthenticatedSession session = (CDOAuthenticatedSession)CDOAuthenticatedSession.get();
        User user = session.getUser();
        if (user != null) {
            return user.hasPermission(this.getRequiredPermission());
        }
        User anonymousUser = session.getAnonymousUser();
        boolean allowed = anonymousUser.hasPermission(this.getRequiredPermission());
        if (allowed) {
            return true;
        }
        throw new RestartResponseAtInterceptPageException(LoginPage.class);
    }

    @Override
    public final WebMarkupContainer createContents(String id, IModel<T> input, Preferences config) {
        this.model = input;
        return this.doCreateContents(id, input, config);
    }

    protected abstract WebMarkupContainer doCreateContents(String var1, IModel<T> var2, Preferences var3);
}

