/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jabylon.properties.Resolvable;
import org.jabylon.rest.ui.wicket.config.ConfigSection;
import org.jabylon.rest.ui.wicket.config.ConfigTabPanel;
import org.osgi.service.prefs.Preferences;

public class ConfigTab<T extends Resolvable<?, ?>>
implements ITab {
    private static final long serialVersionUID = 1L;
    private String title;
    private List<ConfigSection<T>> sections;
    private IModel<T> model;
    private Preferences preferences;

    public ConfigTab(String title, List<ConfigSection<T>> sections, IModel<T> model, Preferences preferences) {
        this.title = title;
        this.sections = sections;
        this.model = model;
        this.preferences = preferences;
    }

    public IModel<String> getTitle() {
        return Model.of((Serializable)((Object)this.title));
    }

    public WebMarkupContainer getPanel(String containerId) {
        ConfigTabPanel<T> panel = new ConfigTabPanel<T>(containerId, this.sections, this.model, this.preferences);
        return panel;
    }

    public boolean isVisible() {
        if (this.sections == null) {
            return false;
        }
        for (ConfigSection<T> section : this.sections) {
            if (!section.isVisible(this.model, this.preferences)) continue;
            return true;
        }
        return false;
    }
}

