/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.jabylon.rest.ui.model.IEObjectModel;
import org.jabylon.rest.ui.model.WritableEObjectModel;
import org.jabylon.rest.ui.security.RestrictedComponent;
import org.jabylon.rest.ui.wicket.JabylonApplication;
import org.jabylon.rest.ui.wicket.config.SettingsOverviewPanel;
import org.jabylon.rest.ui.wicket.config.SettingsPanel;
import org.jabylon.rest.ui.wicket.pages.GenericResolvablePage;
import org.jabylon.rest.ui.wicket.panels.BreadcrumbPanel;

public class SettingsPage
extends GenericResolvablePage<CDOObject>
implements RestrictedComponent {
    private static final long serialVersionUID = 1L;

    public SettingsPage(PageParameters parameters) {
        super(parameters);
        this.setStatelessHint(false);
    }

    @Override
    protected void construct() {
        super.construct();
        BreadcrumbPanel breadcrumbPanel = new BreadcrumbPanel("breadcrumb-panel", this.getModel(), this.getPageParameters());
        breadcrumbPanel.setRootLabel((IModel<String>)new StringResourceModel("SettingsPage.breadcrumb.root.label", (Component)this, null, new Object[0]));
        this.add(new Component[]{breadcrumbPanel});
        if (this.getPageParameters().getIndexedCount() > 0) {
            this.addOrReplace(new Component[]{new SettingsPanel("content", this.getModel(), this.getPageParameters())});
        } else {
            this.addOrReplace(new Component[]{new SettingsOverviewPanel("content")});
        }
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JabylonApplication.get().getJavaScriptLibrarySettings().getJQueryReference())));
        super.renderHead(response);
    }

    @Override
    protected CDOObject doLookup(List<String> segments) {
        try {
            Object resolvable = super.doLookup(segments);
            CDOView cdoView = resolvable.cdoView();
            if (cdoView instanceof CDOTransaction) {
                return resolvable;
            }
            return (CDOObject)cdoView.getSession().openTransaction().getObject(resolvable);
        }
        catch (ClassCastException e) {
            this.getPageParameters().remove(segments.size() - 1);
            return this.doLookup(segments.subList(0, segments.size() - 1));
        }
    }

    @Override
    protected IEObjectModel<CDOObject> createModel(CDOObject object) {
        return new WritableEObjectModel<CDOObject>(object);
    }

    @Override
    public String getRequiredPermission() {
        return null;
    }
}

