/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.Directory;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jabylon.common.progress.RunnableWithProgress;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.index.properties.IndexActivator;
import org.jabylon.index.properties.QueryService;
import org.jabylon.properties.Workspace;
import org.jabylon.rest.ui.Activator;
import org.jabylon.rest.ui.model.PreferencesPropertyModel;
import org.jabylon.rest.ui.model.ProgressionModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.components.ProgressPanel;
import org.jabylon.rest.ui.wicket.components.ProgressShowingAjaxButton;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.validators.CronValidator;
import org.jabylon.scheduler.ScheduleServiceException;
import org.jabylon.scheduler.SchedulerService;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingConfigSection
extends BasicPanel<Workspace> {
    private static final long serialVersionUID = 1L;
    @Inject
    private QueryService queryService;
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingConfigSection.class);
    private ProgressionModel progressModel;
    @Inject
    private SchedulerService scheduler;
    private Preferences config;

    public IndexingConfigSection(String id, IModel<Workspace> model, Preferences config) {
        super(id, model);
        this.config = config;
    }

    @Override
    protected void construct() {
        super.construct();
        this.setOutputMarkupId(true);
        this.progressModel = new ProgressionModel("");
        this.add(new Component[]{new Label("summary", (IModel)new StringResourceModel("index.size.summary", (Component)this, null, new Object[]{this.getIndexSize()}))});
        ProgressPanel progressPanel = new ProgressPanel("progress", this.progressModel);
        this.add(new Component[]{progressPanel});
        this.add(new Component[]{this.createUpdateIndexAction(progressPanel)});
        Preferences indexJobConfig = PreferencesUtil.getNodeForJob((Preferences)this.config, (String)"job.reorg.index");
        PreferencesPropertyModel updateModel = new PreferencesPropertyModel(indexJobConfig, "schedule", "0 0 2 * * ?");
        ControlGroup indexCronGroup = new ControlGroup("index-cron-group", (IModel<String>)this.nls("index.cron.label", new Object[0]), (IModel<String>)this.nls("index.cron.description", new Object[0]));
        TextField<String> indexCron = new TextField<String>("index-cron", (IModel)updateModel){
            private static final long serialVersionUID = 1572798560921411829L;

            protected void convertInput() {
                String tmp;
                super.convertInput();
                String[] value = this.getInputAsArray();
                String string = tmp = value != null && value.length > 0 ? value[0] : null;
                if (tmp == null) {
                    this.setConvertedInput("");
                }
            }
        };
        indexCron.add((IValidator)new CronValidator());
        indexCron.setConvertEmptyInputStringToNull(false);
        indexCronGroup.add(new Component[]{indexCron});
        this.add(new Component[]{indexCronGroup});
        if (this.scheduler != null) {
            try {
                Date nextExecution = this.scheduler.nextExecution(indexJobConfig);
                if (nextExecution != null) {
                    indexCronGroup.setExtraLabel((IModel<String>)this.nls("next.schedule.label", this.format(nextExecution)));
                }
            }
            catch (ScheduleServiceException e) {
                LOGGER.warn("failed to retrieve next job execution for {}", (Object)indexJobConfig.absolutePath());
            }
        }
    }

    protected String format(Date nextExecution) {
        long current = System.currentTimeMillis();
        if (nextExecution.getTime() - current < TimeUnit.HOURS.toMillis(23L)) {
            return SimpleDateFormat.getTimeInstance(3, this.getLocale()).format(nextExecution);
        }
        return SimpleDateFormat.getDateTimeInstance(3, 3, this.getLocale()).format(nextExecution);
    }

    private long getIndexSize() {
        Directory directory = IndexActivator.getDefault().getOrCreateDirectory();
        long size = 0L;
        try {
            if (directory != null) {
                String[] files;
                for (String file : files = directory.listAll()) {
                    size += directory.fileLength(file);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to compute index size", (Throwable)e);
        }
        return size / 1024L;
    }

    protected Component createUpdateIndexAction(ProgressPanel progressPanel) {
        RunnableWithProgress runnable = new RunnableWithProgress(){
            private static final long serialVersionUID = 1L;

            public IStatus run(IProgressMonitor monitor) {
                Activator.getDefault().getRepositoryConnector();
                try {
                    IndexingConfigSection.this.queryService.rebuildIndex(monitor);
                }
                catch (CorruptIndexException e) {
                    return new Status(4, "org.jabylon.rest.ui", "Failed to rebuild index", (Throwable)e);
                }
                catch (IOException e) {
                    return new Status(4, "org.jabylon.rest.ui", "Failed to rebuild index", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        return new ProgressShowingAjaxButton("update-index", progressPanel, runnable, (IModel<String>)this.nls("update.index.job.label", new Object[0]));
    }

    public static class IndexingConfig
    extends AbstractConfigSection<Workspace> {
        private static final long serialVersionUID = 1L;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<Workspace> input, Preferences prefs) {
            return new IndexingConfigSection(id, input, prefs);
        }

        @Override
        public void commit(IModel<Workspace> input, Preferences config) {
        }

        @Override
        public String getRequiredPermission() {
            String projectName = null;
            if (this.getDomainObject() != null) {
                projectName = ((Workspace)this.getDomainObject()).getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"Workspace", projectName, "config"});
        }
    }
}

